/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services.addon;

import java.io.File;
import org.jflux.impl.services.rk.osgi.SingleServiceListener;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ConfigurationAdapter;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.api.common.services.ServiceConnectionDirectory;
import org.robokind.api.common.services.ServiceContext;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;

public class DefaultAddOnDriver<AddOn, Config>
implements ServiceAddOnDriver<AddOn> {
    private BundleContext myContext;
    private VersionProperty myServiceVersion;
    private VersionProperty myConfigFormat;
    private Class<AddOn> myAddOnClass;
    private ConfigurationAdapter<AddOn, Config> myConfigAdapter;
    private SingleServiceListener<ConfigurationWriter<Config, File>> myWriterTracker;

    public DefaultAddOnDriver(BundleContext context, VersionProperty serviceVersion, VersionProperty configFormat, ConfigurationAdapter<AddOn, Config> configAdapter) {
        if (context == null || serviceVersion == null || configFormat == null || configAdapter == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myServiceVersion = serviceVersion;
        this.myConfigFormat = configFormat;
        this.myConfigAdapter = configAdapter;
        this.myAddOnClass = this.myConfigAdapter.getSerivceClass();
        this.myWriterTracker = ServiceUtils.createWriterServiceListener(context, this.myConfigAdapter.getConfigurationClass(), File.class, configFormat, null);
        this.myWriterTracker.start();
    }

    @Override
    public VersionProperty getServiceVersion() {
        return this.myServiceVersion;
    }

    @Override
    public VersionProperty getConfigurationFormat() {
        return this.myConfigFormat;
    }

    @Override
    public Class<AddOn> getServiceClass() {
        return this.myAddOnClass;
    }

    @Override
    public ServiceAddOn<AddOn> loadAddOn(File file) throws Exception {
        if (file == null) {
            throw new NullPointerException();
        }
        ServiceContext<AddOn, ?, File> sc = ServiceConnectionDirectory.buildServiceContext(this.myContext, this.myServiceVersion, this.myConfigFormat, this.myAddOnClass, File.class);
        if (sc == null) {
            return null;
        }
        sc.setLoadParameter(file);
        if (!sc.buildService()) {
            return null;
        }
        AddOn addon = sc.getService();
        if (addon == null) {
            return null;
        }
        return new ServiceAddOn.DefaultAddOn<AddOn>(addon, this);
    }

    @Override
    public boolean writeServiceConfig(AddOn addon, File file) throws Exception {
        Config config = this.myConfigAdapter.createConfig(addon);
        ConfigurationWriter writer = (ConfigurationWriter)this.myWriterTracker.getService();
        if (writer == null) {
            return false;
        }
        return writer.writeConfiguration(config, file);
    }
}

