/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.api.messaging;

import org.robokind.api.common.playable.Playable;

/**
 * RemoteService is an interface for controlling a Service through Messaging.
 * RemoteService extends Playable, offering methods to start, pause, resume, 
 * and stop the service.
 * 
 * @author Matthew Stevenson <www.robokind.org>
 * @param <T> type of configuration used to initialize the Service.
 */
public interface RemoteService<T> extends Playable{
    /**
     * Initializes the Service with the given config.
     * @param config the configuration object used to initialize the Service
     * @throws Exception if there is an error initializing
     */
    public void initialize(T config) throws Exception;    
    /**
     * Returns the class of the config used to initialize.
     * @return class of the config used to initialize
     */
    public Class<T> getConfigClass();
    /**
     * Returns an empty config which is used during initialization.
     * @return empty config which is used during initialization
     */
    public T getReusableConfig();
}
