/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jflux.api.core.util.Adapter;
import org.jflux.api.core.util.Listener;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.RecordBlockingReceiver;

public class DefaultMessageBlockingReceiver<Msg, Rec>
implements MessageBlockingReceiver<Msg> {
    private static final Logger theLogger = Logger.getLogger(DefaultMessageBlockingReceiver.class.getName());
    private RecordBlockingReceiver<Rec> myRecordReceiver;
    private Adapter<Rec, Msg> myAdapter;
    private List<Listener<Msg>> myListeners = new ArrayList<Listener<Msg>>();

    public void setRecordReceiver(RecordBlockingReceiver<Rec> receiver) {
        this.myRecordReceiver = receiver;
    }

    public void setAdapter(Adapter<Rec, Msg> adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void start() {
        if (this.myRecordReceiver == null) {
            theLogger.warning("No Record PollingService, unable to receive.");
            return;
        }
        if (this.myAdapter == null) {
            theLogger.warning("No Record Adapter, unable to send receive.");
            return;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Msg fetchMessage(long timeout) {
        if (this.myRecordReceiver == null || this.myAdapter == null) {
            throw new NullPointerException();
        }
        Rec rec = this.myRecordReceiver.fetchRecord(timeout);
        if (rec == null) {
            return null;
        }
        Object msg = this.myAdapter.adapt(rec);
        if (msg != null) {
            this.fireMessageEvent(msg);
        }
        return (Msg)msg;
    }

    protected void fireMessageEvent(Msg message) {
        for (Listener<Msg> listener : this.myListeners) {
            listener.handleEvent(message);
        }
    }

    @Override
    public int clearMessages() {
        return this.myRecordReceiver.clearRecords();
    }

    @Override
    public void addMessageListener(Listener<Msg> listener) {
        if (listener == null) {
            return;
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeMessageListener(Listener<Msg> listener) {
        if (listener == null) {
            return;
        }
        this.myListeners.remove(listener);
    }
}

