/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.messaging;

/**
 * Sends a Record to some RecordReceiver.
 * A Record is a serialized Message which can be easily transported or 
 * persisted.
 * 
 * @param <T> type of Record sent by this RecordSender
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface RecordSender<T> {
    /**
     * Sends the given record to some RecordReceiver.
     * @param record the record to send
     */
    public void sendRecord(T record);
}
