/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.api.motion.jointgroup;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.motion.Robot.Id;
import org.robokind.api.motion.Robot.JointId;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class RobotJointGroupFactory implements ServiceFactory<JointGroup, RobotJointGroupConfig> {

    @Override
    public VersionProperty getServiceVersion() {
        return RobotJointGroup.VERSION;
    }

    @Override
    public JointGroup build(RobotJointGroupConfig config) {
        if(config == null){
            throw new NullPointerException();
        }
        RobotJointGroup root = buildRec(config);
        Id robotId = config.getRobotId();
        root.initRobotListener(robotId);
        return root;
    }
    
    private RobotJointGroup buildRec(RobotJointGroupConfig config){
        if(config == null){
            return null;
        }
        List<RobotJointGroup> jointGroups = new ArrayList<RobotJointGroup>(config.getGroupCount());
        for(RobotJointGroupConfig child : config.getJointGroups()){
            RobotJointGroup djg = buildRec(child);
            if(djg == null){
                continue;
            }
            jointGroups.add(djg);
        }
        String name = config.getName();
        List<JointId> ids = config.getJointIds();
        return new RobotJointGroup(name, ids, jointGroups);
    }

    @Override
    public Class<JointGroup> getServiceClass() {
        return JointGroup.class;
    }

    @Override
    public Class<RobotJointGroupConfig> getServiceConfigurationClass() {
        return RobotJointGroupConfig.class;
    }
    
}
