package org.robokind.api.motion.messaging;

/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


import org.osgi.framework.BundleContext;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.Robot.RobotPositionMap;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.utils.RobotFrameSource;

/**
 * Listens for MotionFrameEvents and passes them a RobotFrameSource.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class MoveFrameListener implements Listener<MotionFrameEvent>{
    private RobotFrameSource myRobotFrameSource;
    
    public MoveFrameListener(){}
    
    public MoveFrameListener(BundleContext context, Robot.Id robotId){
        
    }
    
    /**
     * Sets the RobotFrameSource to pass goal positions to.
     * @param robotFrameSource RobotFrameSource to use
     */
    public void setRobotFrameSource(RobotFrameSource robotFrameSource){
        myRobotFrameSource = robotFrameSource;
    }
    
    @Override
    public void handleEvent(MotionFrameEvent event) {
        if(myRobotFrameSource == null){
            return;
        }else if(event == null){
            return;
        }else if(event.getMotionFrame() == null){
            return;
        }
        RobotPositionMap goals = event.getMotionFrame().getGoalPositions();
        long duration = event.getMotionFrame().getFrameLengthMillisec();
        if(goals == null){
            return;
        }
        myRobotFrameSource.move(goals, duration);
    }
    
}
