/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.messaging.messages;

import java.util.List;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface RobotDefinitionResponse extends RobotResponse{
        public boolean getConnected();
        public boolean getEnabled();
        public List<JointDefinition> getJointDefinitions();
        
        public static interface JointDefinition{
            public Joint.Id getJointId();
            public String getName();
            public NormalizedDouble getDefaultPosition();
            public NormalizedDouble getGoalPosition();
            public boolean getEnabled();
        }
}
