/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.messaging.messages;

import org.robokind.api.motion.Robot;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface RobotRequest {
    public final static String CMD_GET_ROBOT_DEFINITION = "getRobotDefinition";
    public final static String CMD_CONNECT_ROBOT = "connectRobot";
    public final static String CMD_DISCONNECT_ROBOT = "disconnectRobot";
    public final static String CMD_GET_CONNECTION_STATUS = "getConnectionStatus";
    public final static String CMD_ENABLE_ROBOT = "enableRobot";
    public final static String CMD_DISABLE_ROBOT = "disableRobot";
    public final static String CMD_GET_ENABLED_STATUS = "getEnabledStatus";
    public final static String CMD_ENABLE_JOINT = "enableJoint";
    public final static String CMD_DISABLE_JOINT = "disableJoint";
    public final static String CMD_GET_JOINT_ENABLED_STATUS = "getJointEnabledStatus";
    public final static String CMD_GET_DEFAULT_POSITIONS = "getDefaultPositions";
    public final static String CMD_GET_GOAL_POSITIONS = "getGoalPositions";
    public final static String CMD_GET_CURRENT_POSITIONS = "getGoalPositions";
    public final static String CMD_SEND_MOVE = "sendMove";
    
    public Robot.Id getRobotId();
    public String getSourceId();
    public String getDestinationId();
    public String getRequestType();
    public Integer getRequestIndex();
    public long getTimestampMillisecUTC();
}
