/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.messaging.messages;

import org.robokind.api.motion.Robot;
import org.robokind.api.motion.Robot.RobotPositionMap;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface RobotResponse {
    public RobotResponseHeader getResponseHeader();
    
    public static interface RobotResponseHeader{
        public Robot.Id getRobotId();
        public String getSourceId();
        public String getDestinationId();
        public long getRequestTimestampMillisecUTC();
        public long getResponseTimestampMillisecUTC();
        public String getRequestType();
    }
    
    public static interface RobotStatusResponse extends RobotResponse {
        public boolean getStatusResponse();
    }
    
    public static interface RobotPositionResponse extends RobotResponse {
        public RobotPositionMap getPositionMap();
    }
}
