/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.messaging.messages;

import org.robokind.api.motion.Robot;
import org.robokind.api.motion.Robot.RobotPositionMap;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotPositionResponse;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotResponseHeader;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotStatusResponse;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface RobotResponseFactory{
    public RobotResponseHeader createHeader(Robot.Id robotId, String sourceId, String destinationId, String commandType, long requestTimestamp);
    public RobotDefinitionResponse createDefinitionResponse(RobotResponseHeader header, Robot robot);
    public RobotStatusResponse createStatusResponse(RobotResponseHeader header, boolean status);
    public RobotPositionResponse createPositionResponse(RobotResponseHeader header, RobotPositionMap positions);
}
