/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Robot;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class RobotManager extends PropertyChangeNotifier{
    public final static String PROP_ADD_ROBOT = "addRobot";
    public final static String PROP_REMOVE_ROBOT = "removeRobot";
    public final static String PROP_SELECT_ROBOT = "selectRobot";
    
    
    private Map<Robot.Id,RobotController> myControllerMap;
    private Map<Robot.Id,ServiceRegistration> myRegistrationMap;
    private List<RobotController> myControllerList;
    private BundleContext myContext;
    private Robot.Id mySelectedRobot;
    
    public RobotManager(BundleContext context){
        if(context == null){
            throw new NullPointerException();
        }
        myContext = context;
        myControllerMap = new HashMap();
        myRegistrationMap = new HashMap();
        myControllerList = new ArrayList<RobotController>();
    }
    
    public void addRobot(Robot.Id robotId){
        if(robotId == null){
            throw new NullPointerException();
        }
        if(myControllerMap.containsKey(robotId)){
            return;
        }
        RobotController controller = new RobotController(myContext, this);
        controller.setRobotId(robotId);
        myControllerMap.put(robotId, controller);
        myControllerList.add(controller);
        int index = myControllerList.indexOf(controller);
        fireIndexedPropertyChange(PROP_ADD_ROBOT, index, null, controller);
    }
    
    public void addServiceRegistration(
            Robot.Id robotId, ServiceRegistration registration){
        myRegistrationMap.put(robotId, registration);
        if(!myControllerMap.containsKey(robotId)){
            addRobot(robotId);
        }
    }
    
    public void removeRobot(Robot.Id robotId){
        RobotController rc = myControllerMap.remove(robotId);
        int index = -1;
        if(rc != null){
            rc.disconnectRobot();
            index = myControllerList.indexOf(rc);
            myControllerList.remove(rc);
        }
        ServiceRegistration reg = myRegistrationMap.remove(robotId);
        if(reg != null){
            reg.unregister();
        }
        fireIndexedPropertyChange(PROP_REMOVE_ROBOT, index, null, rc);
    }
    
    public Map<Robot.Id, RobotController> getControllerMap(){
        return myControllerMap;
    }
    
    public void selectRobot(Robot.Id robotId){
        
    }
    
    public List<RobotController> getControllers(){
        return myControllerList;
    }
}
