/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.jointgroup;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.robokind.api.motion.jointgroup.RobotJointGroup;
import org.robokind.api.motion.jointgroup.RobotJointGroupConfig;

public class RobotJointGroupFactory
implements ServiceFactory<JointGroup, RobotJointGroupConfig> {
    public VersionProperty getServiceVersion() {
        return RobotJointGroup.VERSION;
    }

    public JointGroup build(RobotJointGroupConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        RobotJointGroup root = this.buildRec(config);
        Robot.Id robotId = config.getRobotId();
        root.initRobotListener(robotId);
        return root;
    }

    private RobotJointGroup buildRec(RobotJointGroupConfig config) {
        if (config == null) {
            return null;
        }
        ArrayList<RobotJointGroup> jointGroups = new ArrayList<RobotJointGroup>(config.getGroupCount());
        for (RobotJointGroupConfig child : config.getJointGroups()) {
            RobotJointGroup djg = this.buildRec(child);
            if (djg == null) continue;
            jointGroups.add(djg);
        }
        String name = config.getName();
        List<Robot.JointId> ids = config.getJointIds();
        return new RobotJointGroup(name, ids, (List<RobotJointGroup>)jointGroups);
    }

    public Class<JointGroup> getServiceClass() {
        return JointGroup.class;
    }

    public Class<RobotJointGroupConfig> getServiceConfigurationClass() {
        return RobotJointGroupConfig.class;
    }
}

