/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.messages.RobotRequest;
import org.robokind.api.motion.messaging.messages.RobotResponse;
import org.robokind.api.motion.messaging.messages.RobotResponseFactory;
import org.robokind.api.motion.protocol.MotionFrameEvent;

public class RemoteRobotHost {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotHost.class.getName());
    private Robot myRobot;
    private String mySourceId;
    private String myDestinationId;
    private MessageSender<RobotResponse, ?, Listener<RobotResponse>> myResponseSender;
    private MessageAsyncReceiver<RobotRequest, ?, Listener<RobotRequest>> myRequestReceiver;
    private RequestListener myRequestListener;
    private RobotResponseFactory myResponseFactory;
    private MessageAsyncReceiver<MotionFrameEvent, ?, Listener<MotionFrameEvent>> myMotionFrameReceiver;
    private Listener<MotionFrameEvent> myMoveHandler;
    private boolean myStartFlag;

    public RemoteRobotHost(Robot robot, String sourceId, String destinationId, MessageSender<RobotResponse, ?, Listener<RobotResponse>> sender, MessageAsyncReceiver<RobotRequest, ?, Listener<RobotRequest>> receiver, RobotResponseFactory factory, MessageAsyncReceiver<MotionFrameEvent, ?, Listener<MotionFrameEvent>> motionFrameReceiver, Listener<MotionFrameEvent> moveHandler) {
        this(sourceId, destinationId);
        this.initialize(robot, sender, receiver, factory, motionFrameReceiver, moveHandler);
    }

    protected RemoteRobotHost(String sourceId, String destinationId) {
        if (sourceId == null || destinationId == null) {
            throw new NullPointerException();
        }
        this.myStartFlag = false;
        this.mySourceId = sourceId;
        this.myDestinationId = destinationId;
    }

    private void initialize(Robot robot, MessageSender<RobotResponse, ?, Listener<RobotResponse>> sender, MessageAsyncReceiver<RobotRequest, ?, Listener<RobotRequest>> receiver, RobotResponseFactory factory, MessageAsyncReceiver<MotionFrameEvent, ?, Listener<MotionFrameEvent>> motionFrameReceiver, Listener<MotionFrameEvent> moveHandler) {
        if (robot == null || sender == null || receiver == null || factory == null) {
            throw new NullPointerException();
        }
        this.myRobot = robot;
        this.myResponseSender = sender;
        this.myRequestReceiver = receiver;
        this.myResponseFactory = factory;
        this.myMotionFrameReceiver = motionFrameReceiver;
        this.myMoveHandler = moveHandler;
    }

    protected void setRobot(Robot robot) {
        if (robot == null) {
            throw new NullPointerException();
        }
        this.myRobot = robot;
    }

    protected void setResponseSender(MessageSender<RobotResponse, ?, Listener<RobotResponse>> sender) {
        if (sender == null) {
            throw new NullPointerException();
        }
        this.myResponseSender = sender;
    }

    protected void setRequestReceiver(MessageAsyncReceiver<RobotRequest, ?, Listener<RobotRequest>> receiver) {
        if (receiver == null) {
            throw new NullPointerException();
        }
        this.myRequestReceiver = receiver;
    }

    protected void setResponseFactory(RobotResponseFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.myResponseFactory = factory;
    }

    protected void setMotionFrameReceiver(MessageAsyncReceiver<MotionFrameEvent, ?, Listener<MotionFrameEvent>> receiver) {
        if (receiver == null) {
            throw new NullPointerException();
        }
        this.myMotionFrameReceiver = receiver;
    }

    protected void setMoveHandle(Listener<MotionFrameEvent> moveHandler) {
        if (moveHandler == null) {
            throw new NullPointerException();
        }
        this.myMoveHandler = moveHandler;
    }

    public Robot.Id getRobotId() {
        return this.myRobot.getRobotId();
    }

    public String getSourceId() {
        return this.mySourceId;
    }

    public String getDestinationId() {
        return this.myDestinationId;
    }

    public void start() {
        if (this.myRequestReceiver == null || this.myMotionFrameReceiver == null || this.myMoveHandler == null) {
            throw new NullPointerException();
        }
        if (this.myStartFlag) {
            return;
        }
        if (this.myRequestListener == null) {
            this.myRequestListener = new RequestListener();
            this.myRequestReceiver.addMessageListener((Listener)this.myRequestListener);
        }
        this.myMotionFrameReceiver.addMessageListener(this.myMoveHandler);
        this.myStartFlag = true;
    }

    private Robot getRobot() {
        return this.myRobot;
    }

    protected void handleDefinitionRequest(RobotRequest req) {
        this.sendDefinitionResponse(req);
    }

    protected void handleConnectRequest(RobotRequest req) {
        this.sendStatusResponse(req, this.getRobot().connect());
    }

    protected void handleDisconnectRequest(RobotRequest req) {
        this.getRobot().disconnect();
        this.sendStatusResponse(req, true);
    }

    protected void handleConnectionStatusRequest(RobotRequest req) {
        this.sendStatusResponse(req, this.getRobot().isConnected());
    }

    protected void handleEnableRequest(RobotRequest req) {
        this.getRobot().setEnabled(true);
        this.sendStatusResponse(req, true);
    }

    protected void handleDisableRequest(RobotRequest req) {
        this.getRobot().setEnabled(false);
        this.sendStatusResponse(req, true);
    }

    protected void handleEnabledStatusRequest(RobotRequest req) {
        this.sendStatusResponse(req, this.getRobot().isEnabled());
    }

    protected void handleEnableRequestForJoint(RobotRequest req) {
        this.getRequestedJoint(req).setEnabled(true);
        this.sendStatusResponse(req, true);
    }

    protected void handleDisableRequestForJoint(RobotRequest req) {
        this.getRequestedJoint(req).setEnabled(false);
        this.sendStatusResponse(req, true);
    }

    protected void handleEnabledStatusRequestForJoint(RobotRequest req) {
        this.sendStatusResponse(req, this.getRequestedJoint(req).getEnabled());
    }

    protected Joint getRequestedJoint(RobotRequest req) {
        Integer jIdInt = req.getRequestIndex();
        if (jIdInt == null) {
            throw new NullPointerException();
        }
        Joint.Id jId = new Joint.Id(jIdInt);
        Robot.Id rId = req.getRobotId();
        Robot.JointId jointId = new Robot.JointId(rId, jId);
        Object j = this.getRobot().getJoint(jointId);
        if (j == null) {
            throw new NullPointerException();
        }
        return j;
    }

    protected void handleDefaultPositionRequest(RobotRequest req) {
        this.sendPositionResponse(req, this.getRobot().getDefaultPositions());
    }

    protected void handleGoalPositionRequest(RobotRequest req) {
        this.sendPositionResponse(req, this.getRobot().getGoalPositions());
    }

    protected void handleCurrentPositionRequest(RobotRequest req) {
        this.sendPositionResponse(req, this.getRobot().getCurrentPositions());
    }

    private void sendDefinitionResponse(RobotRequest req) {
        this.myResponseSender.sendMessage((Object)this.myResponseFactory.createDefinitionResponse(this.getHeader(req), this.getRobot()));
    }

    private void sendStatusResponse(RobotRequest req, boolean value) {
        this.myResponseSender.sendMessage((Object)this.myResponseFactory.createStatusResponse(this.getHeader(req), value));
    }

    private void sendPositionResponse(RobotRequest req, Robot.RobotPositionMap positions) {
        this.myResponseSender.sendMessage((Object)this.myResponseFactory.createPositionResponse(this.getHeader(req), positions));
    }

    private RobotResponse.RobotResponseHeader getHeader(RobotRequest req) {
        return this.myResponseFactory.createHeader(this.getRobotId(), this.mySourceId, this.myDestinationId, req.getRequestType(), req.getTimestampMillisecUTC());
    }

    class RequestListener
    implements Listener<RobotRequest> {
        RequestListener() {
        }

        public void handleEvent(RobotRequest event) {
            String reqType = event.getRequestType();
            if (reqType.equals("getRobotDefinition")) {
                RemoteRobotHost.this.handleDefinitionRequest(event);
            } else if (reqType.equals("connectRobot")) {
                RemoteRobotHost.this.handleConnectRequest(event);
            } else if (reqType.equals("disconnectRobot")) {
                RemoteRobotHost.this.handleDisconnectRequest(event);
            } else if (reqType.equals("getConnectionStatus")) {
                RemoteRobotHost.this.handleConnectionStatusRequest(event);
            } else if (reqType.equals("enableRobot")) {
                RemoteRobotHost.this.handleEnableRequest(event);
            } else if (reqType.equals("disableRobot")) {
                RemoteRobotHost.this.handleDisableRequest(event);
            } else if (reqType.equals("getEnabledStatus")) {
                RemoteRobotHost.this.handleEnabledStatusRequest(event);
            } else if (reqType.equals("getDefaultPositions")) {
                RemoteRobotHost.this.handleDefaultPositionRequest(event);
            } else if (reqType.equals("getGoalPositions")) {
                RemoteRobotHost.this.handleGoalPositionRequest(event);
            } else if (reqType.equals("getGoalPositions")) {
                RemoteRobotHost.this.handleGoalPositionRequest(event);
            } else if (reqType.equals("enableJoint")) {
                RemoteRobotHost.this.handleEnableRequestForJoint(event);
            } else if (reqType.equals("disableJoint")) {
                RemoteRobotHost.this.handleDisableRequestForJoint(event);
            } else if (reqType.equals("getJointEnabledStatus")) {
                RemoteRobotHost.this.handleEnabledStatusRequestForJoint(event);
            } else {
                theLogger.log(Level.WARNING, "Received unknown request type: {0}", reqType);
            }
        }
    }
}

