/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.ServoRobot;
import org.robokind.api.motion.servos.utils.ServoRobotConnector;
import org.robokind.api.motion.sync.SynchronizedRobotFactory;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "org.robokind.api.motion Activation Begin.");
        this.registerRobotConnector(context);
        ServiceRegistration factReg = ServiceUtils.registerServiceFactory((BundleContext)context, (ServiceFactory)new SynchronizedRobotFactory(), null);
        theLogger.log(Level.INFO, "org.robokind.api.motion Activation Complete.");
    }

    private void registerRobotConnector(BundleContext context) {
        ServoRobotConnector connector = new ServoRobotConnector();
        Properties props = new Properties();
        props.put("ServiceVersion", ServoRobot.VERSION.toString());
        props.put("ServiceClass", Robot.class.getName());
        context.registerService(ServiceFactory.class.getName(), (Object)connector, (Dictionary)props);
        theLogger.log(Level.INFO, "RobotConnector Service Registered Successfully.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

