/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.servos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.config.ServoControllerConfig;

public abstract class AbstractServo<Id, Conf extends ServoConfig<Id>, Ctrl extends ServoController<Id, Conf, ? extends AbstractServo<Id, Conf, Ctrl>, ? extends ServoControllerConfig<Id, Conf>>>
extends PropertyChangeNotifier
implements Servo<Id, Conf>,
PropertyChangeListener {
    private static final Logger theLogger = Logger.getLogger(AbstractServo.class.getName());
    protected Id myServoId;
    protected Conf myConfig;
    protected Ctrl myController;
    protected NormalizedDouble myGoalPosition;

    public AbstractServo(Conf config, Ctrl controller) {
        if (config == null) {
            throw new NullPointerException("Cannot create AbstractServo with null ServoConfig.");
        }
        this.myConfig = config;
        this.myServoId = this.myConfig.getServoId();
        if (this.myServoId == null) {
            throw new NullPointerException();
        }
        this.myController = controller;
    }

    @Override
    public Id getId() {
        return this.myServoId;
    }

    public Ctrl getController() {
        return this.myController;
    }

    @Override
    public Conf getConfig() {
        return this.myConfig;
    }

    @Override
    public NormalizedDouble getGoalPosition() {
        return this.myGoalPosition;
    }

    public Integer getAbsoluteGoalPosition() {
        if (this.myGoalPosition == null) {
            return null;
        }
        double goal = this.myGoalPosition.getValue();
        double range = this.myConfig.getMaxPosition() - this.myConfig.getMinPosition();
        return (int)(goal * range + (double)this.myConfig.getMinPosition());
    }

    @Override
    public void setGoalPosition(NormalizedDouble pos) {
        NormalizedDouble oldPos = this.myGoalPosition;
        this.myGoalPosition = pos;
        this.firePropertyChange("goalPosition", oldPos, pos);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.firePropertyChange(pce);
    }
}

