/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.servos.utils;

import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.ServoJoint;
import org.robokind.api.motion.servos.config.ServoConfig;

public class EmptyServoJoint
extends ServoJoint {
    public EmptyServoJoint(Joint.Id jointId, String name, NormalizedDouble defPos) {
        super(jointId, new EmptyServo(jointId, name, defPos), null);
    }

    static class EmptyServo
    extends PropertyChangeNotifier
    implements Servo {
        private Object myId;
        private String myName;
        private NormalizedDouble myDefaultPosition;
        private NormalizedDouble myGoalPosition;
        private boolean myEnabledFlag;

        private EmptyServo(Object id, String name, NormalizedDouble defPos) {
            if (id == null || name == null || defPos == null) {
                throw new NullPointerException();
            }
            this.myId = id;
            this.myName = name;
            this.myDefaultPosition = defPos;
            this.myGoalPosition = defPos;
            this.myEnabledFlag = true;
        }

        public Object getId() {
            return this.myId;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public NormalizedDouble getDefaultPosition() {
            return this.myDefaultPosition;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.myEnabledFlag = enabled;
        }

        @Override
        public Boolean getEnabled() {
            return this.myEnabledFlag;
        }

        @Override
        public NormalizedDouble getGoalPosition() {
            return this.myGoalPosition;
        }

        @Override
        public void setGoalPosition(NormalizedDouble pos) {
            NormalizedDouble oldPos = this.myGoalPosition;
            this.myGoalPosition = pos;
            this.firePropertyChange("goalPosition", oldPos, pos);
        }

        public ServoConfig getConfig() {
            return null;
        }

        @Override
        public ServoController getController() {
            return null;
        }

        @Override
        public int getMinPosition() {
            return 0;
        }

        @Override
        public int getMaxPosition() {
            return 1023;
        }
    }
}

