/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.utils;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.utils.RobotUtils;

public class PositionTargetFrameSource
implements FrameSource {
    private Robot.RobotPositionMap myTargetPositions;
    private BundleContext myContext;
    private double myVelocity;
    private boolean myEnabledFlag;
    private boolean myStopOnGoalFlag;
    private Robot.Id myRobotId;

    public PositionTargetFrameSource(BundleContext context, Robot.Id robotId, double velocity, Robot.RobotPositionMap targetPositions) {
        if (robotId == null || context == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.myContext = context;
        this.myTargetPositions = new Robot.RobotPositionHashMap();
        if (targetPositions != null) {
            this.myTargetPositions.putAll((Map)((Object)targetPositions));
        }
        this.myVelocity = velocity;
        this.myEnabledFlag = true;
        this.myStopOnGoalFlag = true;
    }

    public Robot.Id getRobotId() {
        return this.myRobotId;
    }

    public void setRobotId(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabledFlag = enabled;
    }

    public boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public void setVelocity(double velocity) {
        if (velocity < 0.0) {
            return;
        }
        this.myVelocity = velocity;
    }

    public double getVelocity() {
        return this.myVelocity;
    }

    public void setStopOnGoal(boolean val) {
        this.myStopOnGoalFlag = val;
    }

    public boolean getStopOnGoalFlag() {
        return this.myStopOnGoalFlag;
    }

    public void putPositions(Robot.RobotPositionMap targetPositions) {
        if (targetPositions == null) {
            return;
        }
        this.myTargetPositions.putAll((Map)((Object)targetPositions));
        this.setEnabled(true);
    }

    public void putPosition(Robot.JointId id, NormalizedDouble position) {
        this.myTargetPositions.put(id, position);
        this.setEnabled(true);
    }

    public void clearPositions() {
        this.myTargetPositions.clear();
        this.setEnabled(false);
    }

    public MotionFrame getMovements(long time, long interval) {
        if (this.myTargetPositions == null || !this.myEnabledFlag || this.myVelocity <= 0.0) {
            return null;
        }
        Robot.RobotPositionMap currentPos = RobotUtils.getGoalPositions(this.myContext, this.myRobotId);
        if (currentPos == null || currentPos.isEmpty()) {
            return null;
        }
        Robot.RobotPositionHashMap goals = new Robot.RobotPositionHashMap();
        DefaultMotionFrame<Robot.RobotPositionHashMap> frame = new DefaultMotionFrame<Robot.RobotPositionHashMap>();
        frame.setTimestampMillisecUTC(time);
        frame.setFrameLengthMillisec(interval);
        boolean atGoal = true;
        for (Map.Entry e : currentPos.entrySet()) {
            Robot.JointId id = (Robot.JointId)e.getKey();
            NormalizedDouble cur = (NormalizedDouble)e.getValue();
            NormalizedDouble goal = (NormalizedDouble)this.myTargetPositions.get(id);
            if (goal == null || cur == null) continue;
            int sign = goal.compareTo((Object)cur) >= 0 ? 1 : -1;
            Double newPos = cur.getValue() + (double)interval * this.myVelocity * (double)sign;
            if (!NormalizedDouble.isValid((double)newPos)) continue;
            NormalizedDouble pos = new NormalizedDouble(newPos.doubleValue());
            pos = sign > 0 ? (pos.compareTo((Object)goal) < 0 ? pos : goal) : (pos.compareTo((Object)goal) > 0 ? pos : goal);
            goals.put(id, pos);
            atGoal = atGoal && cur.equals((Object)goal);
        }
        if (goals.isEmpty()) {
            return null;
        }
        if (this.myStopOnGoalFlag && atGoal) {
            this.setEnabled(false);
        }
        frame.setGoalPositions(goals);
        return frame;
    }
}

