/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.PositionTargetFrameSource;
import org.robokind.api.motion.utils.RobotManager;
import org.robokind.api.motion.utils.RobotUtils;

public class RobotController
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String PROP_ROBOT = "robot";
    public static final String PROP_SELECT_ROBOT = "selectRobot";
    private BundleContext myContext;
    private Robot.Id myRobotId;
    private SingleServiceListener<Robot> myRobotTracker;
    private PositionTargetFrameSource myRobotMover;
    private ServiceRegistration myMoverRegistration;
    private boolean myListenFlag;
    private RobotManager myManager;

    public RobotController(BundleContext context, RobotManager manager) {
        if (context == null || manager == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myListenFlag = false;
        this.myManager = manager;
    }

    public void setRobotId(Robot.Id robotId) {
        Robot oldVal = this.getRobot();
        this.unsetRobot();
        this.myRobotId = robotId;
        if (this.myRobotId == null) {
            this.firePropertyChange(PROP_ROBOT, oldVal, this.myRobotId);
            return;
        }
        this.myRobotTracker = new SingleServiceListener(Robot.class, this.myContext, RobotUtils.getRobotFilter(robotId));
        this.myRobotTracker.start();
        Robot r = this.getRobot();
        if (r != null) {
            r.addPropertyChangeListener(this);
            this.myListenFlag = true;
        }
        this.setRobotMover();
        this.firePropertyChange(PROP_ROBOT, oldVal, this.myRobotId);
    }

    private void unsetRobot() {
        Robot r = this.getRobot();
        this.unregisterMover();
        if (r != null) {
            r.removePropertyChangeListener(this);
        }
        this.myListenFlag = false;
        if (this.myRobotTracker != null) {
            this.myRobotTracker.releaseService();
        }
    }

    public Robot getRobot() {
        if (this.myRobotTracker == null) {
            return null;
        }
        Robot r = (Robot)this.myRobotTracker.getService();
        if (!this.myListenFlag && r != null) {
            r.addPropertyChangeListener(this);
            this.myListenFlag = true;
        }
        return r;
    }

    public boolean connectRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (r.isConnected()) {
            return true;
        }
        return r.connect();
    }

    public boolean disconnectRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (!r.isConnected()) {
            return true;
        }
        r.disconnect();
        return !r.isConnected();
    }

    public boolean enableRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (r.isEnabled()) {
            return true;
        }
        r.setEnabled(true);
        return true;
    }

    public boolean disableRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (!r.isEnabled()) {
            return true;
        }
        r.setEnabled(false);
        return true;
    }

    public boolean selectRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        return false;
    }

    public boolean setDefaultPositions() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        Robot.RobotPositionMap defPos = r.getDefaultPositions();
        this.myRobotMover.putPositions(defPos);
        return true;
    }

    public boolean removeRobot() {
        this.unsetRobot();
        return true;
    }

    private void setRobotMover() {
        this.unregisterMover();
        if (this.myContext == null || this.myRobotId == null) {
            return;
        }
        this.myRobotMover = new PositionTargetFrameSource(this.myContext, this.myRobotId, 0.001, null);
        this.myMoverRegistration = RobotUtils.registerFrameSource(this.myContext, this.myRobotId, this.myRobotMover);
    }

    private void unregisterMover() {
        if (this.myMoverRegistration != null) {
            this.myMoverRegistration.unregister();
        }
        this.myMoverRegistration = null;
        this.myRobotMover = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }
}

