/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.RobotController;

public class RobotManager
extends PropertyChangeNotifier {
    public static final String PROP_ADD_ROBOT = "addRobot";
    public static final String PROP_REMOVE_ROBOT = "removeRobot";
    public static final String PROP_SELECT_ROBOT = "selectRobot";
    private Map<Robot.Id, RobotController> myControllerMap;
    private Map<Robot.Id, ServiceRegistration> myRegistrationMap;
    private List<RobotController> myControllerList;
    private BundleContext myContext;
    private Robot.Id mySelectedRobot;

    public RobotManager(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myControllerMap = new HashMap<Robot.Id, RobotController>();
        this.myRegistrationMap = new HashMap<Robot.Id, ServiceRegistration>();
        this.myControllerList = new ArrayList<RobotController>();
    }

    public void addRobot(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        if (this.myControllerMap.containsKey(robotId)) {
            return;
        }
        RobotController controller = new RobotController(this.myContext, this);
        controller.setRobotId(robotId);
        this.myControllerMap.put(robotId, controller);
        this.myControllerList.add(controller);
        int index = this.myControllerList.indexOf(controller);
        this.fireIndexedPropertyChange(PROP_ADD_ROBOT, index, null, controller);
    }

    public void addServiceRegistration(Robot.Id robotId, ServiceRegistration registration) {
        this.myRegistrationMap.put(robotId, registration);
        if (!this.myControllerMap.containsKey(robotId)) {
            this.addRobot(robotId);
        }
    }

    public void removeRobot(Robot.Id robotId) {
        ServiceRegistration reg;
        RobotController rc = this.myControllerMap.remove(robotId);
        int index = -1;
        if (rc != null) {
            rc.disconnectRobot();
            index = this.myControllerList.indexOf(rc);
            this.myControllerList.remove(rc);
        }
        if ((reg = this.myRegistrationMap.remove(robotId)) != null) {
            reg.unregister();
        }
        this.fireIndexedPropertyChange(PROP_REMOVE_ROBOT, index, null, rc);
    }

    public Map<Robot.Id, RobotController> getControllerMap() {
        return this.myControllerMap;
    }

    public void selectRobot(Robot.Id robotId) {
    }

    public List<RobotController> getControllers() {
        return this.myControllerList;
    }
}

