/*
 *  Copyright (c) 2011 Hanson Robokind LLC. All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *  
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *  
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *  
 *  THIS SOFTWARE IS PROVIDED BY HANSON ROBOKIND LLC "AS IS" AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL HANSON ROBOKIND LLC OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of Hanson Robokind LLC.
 */

package org.robokind.api.motion.blending;

import org.osgi.framework.BundleContext;
import org.robokind.api.motion.Robot;
import org.robokind.api.common.osgi.ClassTracker;
import org.robokind.api.motion.Robot.RobotPositionMap;

/**
 * A BlenderOutput implementation which sends Blender movements to a List of
 * Robots.
 * 
 * @author Matthew Stevenson
 */
public class RobotOutput implements BlenderOutput<RobotPositionMap> {
    private ClassTracker<Robot> myTracker;
    
    /**
     * Creates a new RobotOutput.
     * @param context BundleContext for tracking a robot
     * @param robotId robot to track
     */
    public RobotOutput(BundleContext context, Robot.Id robotId){
        String filter = "(" + Robot.PROP_ID + "=" + robotId +")";
        myTracker = new ClassTracker(context, Robot.class.getName(), filter);
    }
     
    @Override
    public void write(RobotPositionMap positions, long lenMillisec) {
        if(positions == null || positions.isEmpty()){
            return;
        }
        Robot robot = myTracker.getTopService();;
        if(robot == null){
            return;
        }
        robot.move(positions, lenMillisec);
    }

    @Override
    public RobotPositionMap getPositions() {
        Robot dev = myTracker.getTopService();
        if(dev == null){
            return null;
        }
        return dev.getGoalPositions();
    }
}
