/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.api.motion.osgi;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.ServoRobot;
import org.robokind.api.motion.servos.utils.ServoRobotConnector;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.sync.SynchronizedRobotFactory;

/**
 * @author Matthew Stevenson <www.robokind.org>
 */
public class Activator implements BundleActivator {
    private final static Logger theLogger = Logger.getLogger(Activator.class.getName());

    /**
     * 
     * @param context
     * @throws Exception
     */
    @Override
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "org.robokind.api.motion Activation Begin.");
        registerRobotConnector(context);
        ServiceRegistration factReg = ServiceUtils.registerServiceFactory(
                context, new SynchronizedRobotFactory(), null);
        theLogger.log(Level.INFO, 
                "org.robokind.api.motion Activation Complete.");
    }
    
    private void registerRobotConnector(BundleContext context){
        ServoRobotConnector connector = new ServoRobotConnector();
        Properties props = new Properties();
        props.put(ServiceFactory.PROP_SERVICE_VERSION, 
                ServoRobot.VERSION.toString());
        props.put(ServiceFactory.PROP_SERVICE_CLASS, Robot.class.getName());
        context.registerService(
                ServiceFactory.class.getName(), connector, props);
        theLogger.log(Level.INFO,
                "RobotConnector Service Registered Successfully.");
    }

    /**
     * 
     * @param context
     * @throws Exception
     */
    @Override
    public void stop(BundleContext context) throws Exception {}

}
