/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.jointgroup;

import java.util.List;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.ServiceClassListener;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.AbstractJointGroup;

public class RobotJointGroup
extends AbstractJointGroup<Robot.JointId, RobotJointGroup, Joint> {
    public static final String CONFIG_TYPE = "RobotJointGroup";
    public static final String CONFIG_VERSION = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("RobotJointGroup", "1.0");
    private Robot myRobot;
    private ServiceClassListener<Robot> myRobotListener;

    public RobotJointGroup(String name, List<Robot.JointId> ids, List<RobotJointGroup> groups) {
        super(name, ids, groups);
    }

    private void setRobot(Robot robot) {
        Robot old = this.myRobot;
        this.setRobotQuite(robot);
        this.firePropertyChange("structureChanged", old, this.myRobot);
    }

    private void setRobotQuite(Robot robot) {
        if (this.myRobot == robot) {
            return;
        }
        this.myRobot = robot;
        for (RobotJointGroup group : this.myGroups) {
            group.setRobotQuite(robot);
        }
    }

    protected void initRobotListener(Robot.Id robotId) {
        BundleContext context = OSGiUtils.getBundleContext(Robot.class);
        String filter = OSGiUtils.createServiceFilter((String)"robotId", (String)robotId.toString());
        this.myRobotListener = new ServiceClassListener<Robot>(Robot.class, context, filter){

            protected void addService(Robot t) {
                this.setGroupRobot();
            }

            protected void removeService(Robot t) {
                this.setGroupRobot();
            }

            private void setGroupRobot() {
                if (this.myList.isEmpty()) {
                    RobotJointGroup.this.setRobot(null);
                    return;
                }
                Robot robot = (Robot)this.myList.get(0);
                RobotJointGroup.this.setRobot(robot);
            }
        };
    }

    @Override
    protected Joint getJointById(Robot.JointId jointId) {
        if (this.myRobot == null) {
            return null;
        }
        return this.myRobot.getJoint(jointId);
    }
}

