/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.utils;

import java.util.Map;
import java.util.logging.Logger;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.utils.RobotFrameSource;

public class RobotMoverFrameSource
implements RobotFrameSource {
    private static final Logger theLogger = Logger.getLogger(RobotMoverFrameSource.class.getName());
    private Robot myRobot;
    private Robot.RobotPositionMap myPreviousPositions;
    private Robot.RobotPositionMap myGoalPositions;
    private long myMoveLengthMsec;
    private long myMoveStartTime;
    private boolean myFinsihedFlag;

    public RobotMoverFrameSource(Robot robot) {
        this.myRobot = robot;
    }

    @Override
    public void setRobot(Robot robot) {
        this.myRobot = robot;
    }

    @Override
    public Robot getRobot() {
        return this.myRobot;
    }

    public void move(Robot.RobotPositionMap positions, long lenMillisec) {
        if (positions == null || positions.isEmpty()) {
            this.myGoalPositions = null;
            return;
        }
        this.myFinsihedFlag = false;
        this.myGoalPositions = positions;
        this.myMoveLengthMsec = lenMillisec;
        this.myMoveStartTime = 0L;
    }

    @Override
    public MotionFrame getMovements(long currentTimeUTC, long moveLengthMilliSec) {
        if (this.myRobot == null || this.myGoalPositions == null || this.myMoveLengthMsec == 0L || this.myFinsihedFlag) {
            return null;
        }
        if (this.myMoveStartTime == 0L) {
            this.myMoveStartTime = currentTimeUTC;
            this.myPreviousPositions = this.myRobot.getGoalPositions();
        } else if (this.myPreviousPositions == null) {
            this.myPreviousPositions = this.myRobot.getGoalPositions();
        }
        long elapsed = currentTimeUTC + moveLengthMilliSec - this.myMoveStartTime;
        elapsed = Utils.bound((long)elapsed, (long)0L, (long)this.myMoveLengthMsec);
        if (elapsed == this.myMoveLengthMsec) {
            this.myFinsihedFlag = true;
        }
        double timeRatio = (double)elapsed / (double)this.myMoveLengthMsec;
        DefaultMotionFrame<Robot.RobotPositionHashMap> frame = new DefaultMotionFrame<Robot.RobotPositionHashMap>();
        frame.setTimestampMillisecUTC(currentTimeUTC);
        frame.setFrameLengthMillisec(moveLengthMilliSec);
        frame.setPreviousPositions(new Robot.RobotPositionHashMap((Map<? extends Robot.JointId, ? extends NormalizedDouble>)((Object)this.myPreviousPositions)));
        Robot.RobotPositionHashMap goals = new Robot.RobotPositionHashMap(this.myGoalPositions.size());
        for (Map.Entry e : this.myGoalPositions.entrySet()) {
            Robot.JointId jointId = (Robot.JointId)e.getKey();
            NormalizedDouble cur = (NormalizedDouble)this.myPreviousPositions.get(jointId);
            NormalizedDouble goal = (NormalizedDouble)e.getValue();
            if (goal == null) continue;
            if (cur == null) {
                cur = goal;
            }
            double curVal = cur.getValue();
            double diff = goal.getValue() - curVal;
            double step = diff * timeRatio + curVal;
            NormalizedDouble interval = new NormalizedDouble(step);
            goals.put(jointId, interval);
        }
        frame.setGoalPositions(goals);
        return frame;
    }
}

