/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.utils;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Factory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.Blender;
import org.robokind.api.motion.blending.DefaultBlender;
import org.robokind.api.motion.blending.FrameCombiner;
import org.robokind.api.motion.blending.NaiveMotionFrameAverager;
import org.robokind.api.motion.blending.OSGiFrameSourceTracker;
import org.robokind.api.motion.blending.RobotOutput;
import org.robokind.api.motion.blending.TimedBlenderDriver;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.motion.utils.RobotManager;

public class RobotUtils {
    private static final Logger theLogger = Logger.getLogger(RobotUtils.class.getName());
    public static final long DEFAULT_BLENDER_INTERVAL = 40L;
    private static SingleServiceListener<RobotManager> theManagerTracker;

    public static Robot.RobotPositionMap getCurrentPositions(BundleContext context, Robot.Id robotId) {
        ServiceReference ref = RobotUtils.getRobotReference(context, robotId);
        if (ref == null) {
            return null;
        }
        Robot robot = RobotUtils.getRobot(context, ref);
        if (robot == null) {
            return null;
        }
        Robot.RobotPositionMap pos = robot.getCurrentPositions();
        context.ungetService(ref);
        return pos;
    }

    public static Robot.RobotPositionMap getGoalPositions(BundleContext context, Robot.Id robotId) {
        ServiceReference ref = RobotUtils.getRobotReference(context, robotId);
        if (ref == null) {
            return null;
        }
        Robot dev = RobotUtils.getRobot(context, ref);
        if (dev == null) {
            return null;
        }
        Robot.RobotPositionMap pos = dev.getGoalPositions();
        context.ungetService(ref);
        return pos;
    }

    public static Robot.RobotPositionMap getDefaultPositions(BundleContext context, Robot.Id robotId) {
        ServiceReference ref = RobotUtils.getRobotReference(context, robotId);
        if (ref == null) {
            return null;
        }
        Robot dev = RobotUtils.getRobot(context, ref);
        if (dev == null) {
            return null;
        }
        Robot.RobotPositionMap pos = dev.getDefaultPositions();
        context.ungetService(ref);
        return pos;
    }

    public static Map<Robot.JointId, String> getJointNames(BundleContext context, Robot.Id robotId) {
        ServiceReference ref = RobotUtils.getRobotReference(context, robotId);
        if (ref == null) {
            return null;
        }
        Robot dev = RobotUtils.getRobot(context, ref);
        if (dev == null) {
            return null;
        }
        Map<Robot.JointId, String> names = dev.getJointNames();
        context.ungetService(ref);
        return names;
    }

    private static Robot getRobot(BundleContext context, ServiceReference ref) {
        Object obj = context.getService(ref);
        if (!(obj instanceof Robot)) {
            context.ungetService(ref);
            return null;
        }
        return (Robot)obj;
    }

    public static boolean isRobotIdAvailable(BundleContext context, Robot.Id robotId) {
        return RobotUtils.getRobotReference(context, robotId) == null;
    }

    public static ServiceRegistration registerRobot(BundleContext context, Robot robot, Properties props) {
        Robot.Id id = robot.getRobotId();
        if (!RobotUtils.isRobotIdAvailable(context, id)) {
            theLogger.warning("Unable to register Robot.  Id in use or invalid");
            return null;
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("robotId", id.toString());
        ServiceRegistration reg = context.registerService(Robot.class.getName(), (Object)robot, (Dictionary)props);
        theLogger.log(Level.INFO, "Robot Service Registered.");
        RobotManager manager = RobotUtils.getRobotManager(context);
        manager.addServiceRegistration(robot, reg);
        return reg;
    }

    public static ServiceReference getRobotReference(BundleContext context, Robot.Id robotId) {
        if (context == null || robotId == null) {
            throw new NullPointerException();
        }
        String filter = String.format("(%s=%s)", "robotId", robotId.toString());
        try {
            ServiceReference[] refs = context.getAllServiceReferences(Robot.class.getName(), filter);
            if (refs == null || refs.length == 0) {
                return null;
            }
            if (refs.length > 1) {
                theLogger.log(Level.WARNING, "Found multiple Robots with given id: {0}", robotId);
            }
            return refs[0];
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Unable to use robotId.  Given robotId results in invalid OSGi filter.", ex);
            return null;
        }
    }

    public static ServiceRegistration[] startDefaultBlender(BundleContext context, Robot.Id robotId, long blenderIntervalMsec) {
        if (context == null || robotId == null) {
            throw new NullPointerException();
        }
        if (OSGiUtils.serviceExists((BundleContext)context, (Class[])new Class[]{Blender.class, TimedBlenderDriver.class}, (String)RobotUtils.getRobotFilter(robotId)).booleanValue()) {
            return null;
        }
        Properties props = new Properties();
        props.put("robotId", robotId.toString());
        FrameCombiner combiner = RobotUtils.getFrameCombiner();
        RobotOutput output = new RobotOutput(context, robotId);
        OSGiFrameSourceTracker tracker = new OSGiFrameSourceTracker();
        tracker.init(context, OSGiUtils.createServiceFilter((Properties)props));
        DefaultBlender blender = new DefaultBlender();
        blender.setFrameCombiner(combiner);
        blender.setOutput(output);
        TimedBlenderDriver driver = new TimedBlenderDriver(blenderIntervalMsec);
        driver.setBlender(blender);
        driver.setFrameSourceTracker(tracker);
        driver.start();
        ServiceRegistration[] regs = new ServiceRegistration[]{context.registerService(Blender.class.getName(), blender, (Dictionary)props), context.registerService(TimedBlenderDriver.class.getName(), (Object)driver, (Dictionary)props)};
        theLogger.log(Level.INFO, "Blender successfully registered for {0}.", robotId.toString());
        return regs;
    }

    private static FrameCombiner getFrameCombiner() {
        Factory<Robot.RobotPositionMap> factory = new Factory<Robot.RobotPositionMap>(){

            public Robot.RobotPositionMap create() {
                return new Robot.RobotPositionHashMap();
            }
        };
        return new NaiveMotionFrameAverager(factory);
    }

    public static ServiceRegistration registerFrameSource(BundleContext context, Robot.Id robotId, FrameSource frameSource) {
        if (context == null || robotId == null || frameSource == null) {
            throw new NullPointerException();
        }
        Properties props = new Properties();
        props.put("robotId", robotId.toString());
        String clazz = FrameSource.class.getName();
        ServiceRegistration reg = context.registerService(clazz, (Object)frameSource, (Dictionary)props);
        if (reg != null) {
            theLogger.log(Level.INFO, "FrameSource successfully registered for {0}.", robotId.toString());
        } else {
            theLogger.log(Level.INFO, "Unable to register FrameSource for {0}.", robotId.toString());
        }
        return reg;
    }

    public static String getRobotFilter(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        return OSGiUtils.createServiceFilter((String)"robotId", (String)robotId.toString());
    }

    public static String getRobotFilter(Robot.Id robotId, String serviceFilter) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        return OSGiUtils.createIdFilter((String)"robotId", (String)robotId.toString(), (String)serviceFilter);
    }

    public static Map<Integer, Double> convertMap(Robot.RobotPositionMap posMap) {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        int size = posMap.size();
        for (Map.Entry e : posMap.entrySet()) {
            int i = ((Robot.JointId)e.getKey()).getJointId().getLogicalJointNumber();
            while (map.containsKey(i)) {
                i += size;
            }
            double pos = ((NormalizedDouble)e.getValue()).getValue();
            map.put(i, pos);
        }
        return map;
    }

    public static RobotManager getRobotManager(BundleContext context) {
        RobotManager manager;
        if (context == null) {
            throw new NullPointerException();
        }
        if (theManagerTracker == null) {
            theManagerTracker = new SingleServiceListener(RobotManager.class, context, null);
            theManagerTracker.start();
        }
        if ((manager = (RobotManager)((Object)theManagerTracker.getService())) == null) {
            RobotManager tmp = new RobotManager(context);
            context.registerService(RobotManager.class.getName(), (Object)tmp, null);
            manager = (RobotManager)((Object)theManagerTracker.getService());
        }
        if (manager == null) {
            throw new NullPointerException("Unknown error registering and tracking RobotManager.");
        }
        return manager;
    }
}

