/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.blending;

import java.util.HashMap;
import java.util.Map;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Factory;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.blending.FrameCombiner;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;

public class NaiveMotionFrameAverager<Id, PosMap extends JointPositionMap<Id, NormalizedDouble>>
implements FrameCombiner<MotionFrame<PosMap>, FrameSource<PosMap>, PosMap> {
    private Factory<PosMap> myPositionMapFactory;

    public NaiveMotionFrameAverager(Factory<PosMap> posMapFact) {
        if (posMapFact == null) {
            throw new NullPointerException();
        }
        this.myPositionMapFactory = posMapFact;
    }

    @Override
    public PosMap combineFrames(long time, long interval, PosMap curPos, Map<? extends MotionFrame<PosMap>, ? extends FrameSource<PosMap>> frames) {
        HashMap posSums = new HashMap();
        HashMap count = new HashMap();
        for (MotionFrame<PosMap> f : frames.keySet()) {
            this.sumGoalPositions(f, posSums, count);
        }
        JointPositionMap pos = (JointPositionMap)this.myPositionMapFactory.create();
        for (Map.Entry e : posSums.entrySet()) {
            Object id = e.getKey();
            double goal = (Double)e.getValue();
            double c = ((Integer)count.get(id)).intValue();
            double avg = goal / c;
            avg = Utils.bound((double)avg, (double)0.0, (double)1.0);
            NormalizedDouble val = new NormalizedDouble(avg);
            pos.put(id, val);
        }
        return (PosMap)pos;
    }

    private void sumGoalPositions(MotionFrame<PosMap> f, Map<Id, Double> posSums, Map<Id, Integer> count) {
        PosMap goals = f.getGoalPositions();
        if (goals == null) {
            return;
        }
        for (Map.Entry e : goals.entrySet()) {
            Object id = e.getKey();
            NormalizedDouble goal = (NormalizedDouble)e.getValue();
            double val = goal.getValue();
            int c = 1;
            if (posSums.containsKey(id)) {
                val += posSums.get(id).doubleValue();
                c += count.get(id).intValue();
            }
            posSums.put(id, val);
            count.put(id, c);
        }
    }
}

