/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.ManagedServiceGroup;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.common.utils.Factory;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameCombiner;
import org.robokind.api.motion.blending.FrameSourceTracker;
import org.robokind.api.motion.blending.NaiveMotionFrameAverager;
import org.robokind.api.motion.blending.OSGiFrameSourceTracker;
import org.robokind.api.motion.lifecycle.RobotBlenderLifecycle;
import org.robokind.api.motion.lifecycle.RobotOutputLifecycle;
import org.robokind.api.motion.lifecycle.TimedBlenderDriverLifecycle;

public class DefaultBlenderServiceGroup
extends ManagedServiceGroup {
    private static final Logger theLogger = Logger.getLogger(DefaultBlenderServiceGroup.class.getName());

    private static String getIdBase(Robot.Id robotId) {
        String base = "robot/" + robotId + "/blender";
        return base;
    }

    public DefaultBlenderServiceGroup(BundleContext context, Robot.Id robotId, long blenderIntervalMillisec, Properties registrationProperties) {
        super((ManagedServiceFactory)new OSGiComponentFactory(context), DefaultBlenderServiceGroup.getBlenderLifecycles(context, robotId, blenderIntervalMillisec), DefaultBlenderServiceGroup.getIdBase(robotId), registrationProperties);
    }

    private static List<ServiceLifecycleProvider> getBlenderLifecycles(BundleContext context, Robot.Id robotId, long blenderInterval) {
        blenderInterval = DefaultBlenderServiceGroup.validateInterval(blenderInterval);
        ArrayList<ServiceLifecycleProvider> services = new ArrayList<ServiceLifecycleProvider>();
        services.add((ServiceLifecycleProvider)new RobotBlenderLifecycle(robotId));
        services.add((ServiceLifecycleProvider)new RobotOutputLifecycle(robotId));
        services.add((ServiceLifecycleProvider)new TimedBlenderDriverLifecycle(robotId, blenderInterval));
        services.add(DefaultBlenderServiceGroup.buildFrameSourceTrackerLauncher(context, robotId));
        services.add(DefaultBlenderServiceGroup.buildFrameCombinerLauncher(robotId));
        return services;
    }

    private static long validateInterval(long interval) {
        return Utils.bound((long)interval, (long)1L, (long)0x7FFFFFFEL);
    }

    private static ServiceLifecycleProvider<FrameSourceTracker> buildFrameSourceTrackerLauncher(BundleContext context, Robot.Id robotId) {
        Properties props = new Properties();
        props.put("robotId", robotId.getRobtIdString());
        OSGiFrameSourceTracker tracker = new OSGiFrameSourceTracker();
        tracker.init(context, OSGiUtils.createServiceFilter((Properties)props));
        props.put("positionMapType", Robot.RobotPositionMap.class.getName());
        return new SimpleLifecycle((Object)tracker, FrameSourceTracker.class, props);
    }

    private static ServiceLifecycleProvider<FrameCombiner> buildFrameCombinerLauncher(Robot.Id robotId) {
        Properties props = new Properties();
        props.put("robotId", robotId.getRobtIdString());
        props.put("positionMapType", Robot.RobotPositionMap.class.getName());
        return new SimpleLifecycle((Object)DefaultBlenderServiceGroup.getFrameCombiner(), FrameCombiner.class, props);
    }

    private static FrameCombiner getFrameCombiner() {
        Factory<Robot.RobotPositionMap> factory = new Factory<Robot.RobotPositionMap>(){

            public Robot.RobotPositionMap create() {
                return new Robot.RobotPositionHashMap();
            }
        };
        return new NaiveMotionFrameAverager(factory);
    }
}

