/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.Blender;
import org.robokind.api.motion.blending.BlenderOutput;
import org.robokind.api.motion.blending.DefaultBlender;
import org.robokind.api.motion.blending.FrameCombiner;

public class RobotBlenderLifecycle
extends AbstractLifecycleProvider<Blender, DefaultBlender> {
    private static final String theBlenderOutputId = "blenderOutput";
    private static final String theFrameCombinerId = "frameCombiner";

    public RobotBlenderLifecycle(Robot.Id robotId) {
        super(new DescriptorListBuilder().dependency(theBlenderOutputId, BlenderOutput.class).with("robotId", robotId.getRobtIdString()).with("positionMapType", Robot.RobotPositionMap.class.getName()).dependency(theFrameCombinerId, FrameCombiner.class).with("robotId", robotId.getRobtIdString()).with("positionMapType", Robot.RobotPositionMap.class.getName()).getDescriptors());
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
        this.myRegistrationProperties.put("positionMapType", Robot.RobotPositionMap.class.getName());
    }

    protected DefaultBlender create(Map<String, Object> services) {
        BlenderOutput output = (BlenderOutput)services.get(theBlenderOutputId);
        FrameCombiner combiner = (FrameCombiner)services.get(theFrameCombinerId);
        DefaultBlender blender = new DefaultBlender();
        blender.setOutput(output);
        blender.setFrameCombiner(combiner);
        return blender;
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (theBlenderOutputId.equals(serviceId)) {
            ((DefaultBlender)this.myService).setOutput((BlenderOutput)service);
        } else if (theFrameCombinerId.equals(serviceId)) {
            ((DefaultBlender)this.myService).setFrameCombiner((FrameCombiner)service);
        }
    }

    public Class<Blender> getServiceClass() {
        return Blender.class;
    }
}

