/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.Robot;

public abstract class AbstractRobot<J extends Joint>
extends PropertyChangeNotifier
implements Robot<J> {
    private Robot.Id myRobotId;
    private boolean myEnabledFlag;
    protected Map<Robot.JointId, J> myJointMap;
    protected List<J> myJointList;

    public AbstractRobot(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.myJointMap = new HashMap<Robot.JointId, J>();
        this.myJointList = new ArrayList<J>();
    }

    @Override
    public Robot.Id getRobotId() {
        return this.myRobotId;
    }

    @Override
    public J getJoint(Robot.JointId id) {
        if (id == null || this.myJointMap == null) {
            throw new NullPointerException();
        }
        return (J)((Joint)this.myJointMap.get(id));
    }

    @Override
    public Set<Robot.JointId> getJointIds() {
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        return Collections.unmodifiableSet(this.myJointMap.keySet());
    }

    @Override
    public Map<Robot.JointId, J> getJoints() {
        return Collections.unmodifiableMap(this.myJointMap);
    }

    @Override
    public String getJointName(Robot.JointId id) {
        if (id == null || this.myJointMap == null) {
            throw new NullPointerException();
        }
        Joint joint = (Joint)this.myJointMap.get(id);
        if (joint == null) {
            return null;
        }
        return joint.getName();
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabledFlag;
    }

    @Override
    public void setEnabled(boolean val) {
        boolean oldVal = this.myEnabledFlag;
        this.myEnabledFlag = val;
        this.firePropertyChange("isEnabled", oldVal, val);
    }

    @Override
    public Map<Robot.JointId, String> getJointNames() {
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        HashMap<Robot.JointId, String> nameMap = new HashMap<Robot.JointId, String>(this.myJointMap.size());
        for (Map.Entry<Robot.JointId, J> e : this.myJointMap.entrySet()) {
            Robot.JointId id = e.getKey();
            if (id == null) {
                throw new NullPointerException();
            }
            Joint joint = (Joint)e.getValue();
            if (joint == null) {
                throw new NullPointerException();
            }
            nameMap.put(id, joint.getName());
        }
        return nameMap;
    }

    @Override
    public Robot.RobotPositionMap getDefaultPositions() {
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        Robot.RobotPositionHashMap posMap = new Robot.RobotPositionHashMap(this.myJointMap.size());
        for (Map.Entry<Robot.JointId, J> e : this.myJointMap.entrySet()) {
            Robot.JointId id = e.getKey();
            if (id == null) {
                throw new NullPointerException();
            }
            Joint joint = (Joint)e.getValue();
            if (joint == null) {
                throw new NullPointerException();
            }
            posMap.put(id, joint.getDefaultPosition());
        }
        return posMap;
    }

    @Override
    public Robot.RobotPositionMap getCurrentPositions() {
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        Robot.RobotPositionHashMap posMap = new Robot.RobotPositionHashMap(this.myJointMap.size());
        for (Map.Entry<Robot.JointId, J> e : this.myJointMap.entrySet()) {
            Robot.JointId id = e.getKey();
            if (id == null) {
                throw new NullPointerException();
            }
            Joint joint = (Joint)e.getValue();
            if (joint == null) {
                throw new NullPointerException();
            }
            JointProperty<NormalizedDouble> curPos = joint.getProperty("currentPosition", NormalizedDouble.class);
            NormalizedDouble val = curPos == null ? joint.getGoalPosition() : curPos.getValue();
            posMap.put(id, val);
        }
        return posMap;
    }

    @Override
    public Robot.RobotPositionMap getGoalPositions() {
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        Robot.RobotPositionHashMap posMap = new Robot.RobotPositionHashMap(this.myJointMap.size());
        for (Map.Entry<Robot.JointId, J> e : this.myJointMap.entrySet()) {
            Robot.JointId id = e.getKey();
            if (id == null) {
                throw new NullPointerException();
            }
            Joint joint = (Joint)e.getValue();
            if (joint == null) {
                throw new NullPointerException();
            }
            posMap.put(id, joint.getGoalPosition());
        }
        return posMap;
    }

    protected boolean addJoint(J j) {
        Joint.Id jId = j.getId();
        Robot.JointId jointId = new Robot.JointId(this.getRobotId(), jId);
        if (this.myJointMap.containsKey(jointId) || this.myJointList.contains(j)) {
            return false;
        }
        this.myJointMap.put(jointId, j);
        this.myJointList.add(j);
        return true;
    }

    protected boolean removeJoint(J j) {
        Joint.Id jId = j.getId();
        Robot.JointId jointId = new Robot.JointId(this.getRobotId(), jId);
        if (!this.myJointMap.containsKey(jointId) || !this.myJointList.contains(j)) {
            return false;
        }
        this.myJointMap.remove(jointId);
        this.myJointList.remove(j);
        return true;
    }

    protected void clearJoints() {
        this.myJointMap.clear();
        this.myJointList.clear();
    }

    @Override
    public List<J> getJointList() {
        return this.myJointList;
    }
}

