/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.blending;

import java.util.HashMap;
import java.util.Map;
import org.jflux.api.core.util.Factory;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.blending.FrameCombiner;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;

public class VelocityCombiner<Id, PosMap extends JointPositionMap<Id, NormalizedDouble>>
implements FrameCombiner<MotionFrame<PosMap>, FrameSource<PosMap>, PosMap> {
    private Factory<PosMap> myPositionMapFactory;

    public VelocityCombiner(Factory<PosMap> posMapFact) {
        if (posMapFact == null) {
            throw new NullPointerException();
        }
        this.myPositionMapFactory = posMapFact;
    }

    @Override
    public PosMap combineFrames(long time, long interval, PosMap curPos, Map<? extends MotionFrame<PosMap>, ? extends FrameSource<PosMap>> frames) {
        JointPositionMap pos = (JointPositionMap)this.myPositionMapFactory.create();
        HashMap<Id, Double> velocities = new HashMap<Id, Double>();
        if (!frames.isEmpty()) {
            return frames.keySet().iterator().next().getGoalPositions();
        }
        for (MotionFrame<PosMap> f : frames.keySet()) {
            for (Map.Entry<Id, Double> e : this.getVelocities(f).entrySet()) {
                Id id = e.getKey();
                double vel = e.getValue();
                if (velocities.containsKey(id)) {
                    vel += ((Double)velocities.get(id)).doubleValue();
                }
                velocities.put(id, vel);
            }
        }
        for (MotionFrame<Object> i : curPos.keySet()) {
            if (!velocities.containsKey(i)) continue;
            NormalizedDouble goal = (NormalizedDouble)curPos.get(i);
            double val = goal.getValue();
            val += (Double)velocities.get(i) * (double)interval;
            val = Utils.bound((double)val, (double)0.0, (double)1.0);
            pos.put(i, new NormalizedDouble(val));
        }
        return (PosMap)pos;
    }

    private Map<Id, Double> getVelocities(MotionFrame<PosMap> frame) {
        HashMap vels = new HashMap();
        if (frame.getFrameLengthMillisec() <= 0L) {
            return vels;
        }
        for (Object i : frame.getGoalPositions().keySet()) {
            NormalizedDouble goal = (NormalizedDouble)frame.getGoalPositions().get(i);
            NormalizedDouble prev = (NormalizedDouble)frame.getPreviousPositions().get(i);
            if (goal == null || prev == null) {
                vels.put(i, 0.0);
            }
            double diff = goal.getValue() - prev.getValue();
            double vel = diff / (double)frame.getFrameLengthMillisec();
            vels.put(i, vel);
        }
        return vels;
    }
}

