/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobot;
import org.robokind.api.motion.messaging.RemoteRobotClient;

public class RemoteRobotLifecycle
extends AbstractLifecycleProvider<Robot, RemoteRobot> {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotLifecycle.class.getName());
    private static final String theRobotClient = "remoteRobotClient";

    public RemoteRobotLifecycle(Robot.Id robotId) {
        super(new DescriptorListBuilder().dependency(theRobotClient, RemoteRobotClient.class).with("robotId", robotId.getRobtIdString()).getDescriptors());
        if (robotId == null) {
            throw new NullPointerException();
        }
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
    }

    protected RemoteRobot create(Map<String, Object> services) {
        RemoteRobotClient client = (RemoteRobotClient)services.get(theRobotClient);
        try {
            return new RemoteRobot(client);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error starting RemoteRobot messaging components.", ex);
            return null;
        }
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            return;
        }
        if (theRobotClient.equals(serviceId)) {
            this.myService = service != null ? this.create((Map)dependencies) : null;
        }
    }

    public Class<Robot> getServiceClass() {
        return Robot.class;
    }
}

