/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.core.util.Listener;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.messaging.RobotMoveHandler;
import org.robokind.api.motion.protocol.MotionFrameEvent;

public class RobotMoveHandlerLifecycle
extends AbstractLifecycleProvider<Listener, RobotMoveHandler> {
    private static final String theRobot = "robot";

    public RobotMoveHandlerLifecycle(String moveHandlerId, Robot.Id robotId) {
        super(new DescriptorListBuilder().dependency(theRobot, Robot.class).with("robotId", robotId.getRobtIdString()).getDescriptors());
        if (moveHandlerId == null) {
            throw new NullPointerException();
        }
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
        this.myRegistrationProperties.put("listenerId", moveHandlerId);
        this.myRegistrationProperties.put("listenerType", MotionFrameEvent.class.getName());
        this.myRegistrationProperties.put("positionMapType", Robot.RobotPositionMap.class.getName());
        this.myServiceClassNames = new String[]{Listener.class.getName(), FrameSource.class.getName()};
    }

    protected RobotMoveHandler create(Map<String, Object> dependencies) {
        Robot robot = (Robot)dependencies.get(theRobot);
        return new RobotMoveHandler(robot);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theRobot.equals(name)) {
            ((RobotMoveHandler)this.myService).setRobot((Robot)dependency);
        }
    }

    public Class<Listener> getServiceClass() {
        return Listener.class;
    }
}

