/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.servos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.property.PropertyChangeAction;
import org.robokind.api.common.property.PropertyChangeActionBase;
import org.robokind.api.common.property.PropertyChangeMonitor;
import org.robokind.api.common.services.ServiceContext;
import org.robokind.api.motion.AbstractRobot;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.ServoJoint;
import org.robokind.api.motion.servos.config.ServoControllerConfig;
import org.robokind.api.motion.servos.config.ServoRobotConfig;
import org.robokind.api.motion.servos.utils.EmptyServoJoint;
import org.robokind.api.motion.servos.utils.ServoJointAdapter;

public class ServoRobot
extends AbstractRobot<ServoJoint> {
    private static final Logger theLogger = Logger.getLogger(ServoRobot.class.getName());
    public static final String VERSION_NAME = "Servo Robot Implementation";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Servo Robot Implementation", "1.0");
    private Map<Robot.JointId, ServoController.ServoId> myServoIdMap = new HashMap<Robot.JointId, ServoController.ServoId>();
    private Map<ServoController.Id, ServoJointAdapter> myServoJointAdapters;
    private Map<ServoController.Id, ServoController> myControllers = new HashMap<ServoController.Id, ServoController>();
    private List<ServoController> myControllerList = new ArrayList<ServoController>();
    private List<Robot.JointId> myMissingJoints;
    private PropertyChangeMonitor myChangeMonitor;
    private boolean myConnectionFlag = false;

    public ServoRobot(ServoRobotConfig config) {
        super(config.getRobotId());
        this.myServoJointAdapters = new HashMap<ServoController.Id, ServoJointAdapter>();
        this.myMissingJoints = new ArrayList<Robot.JointId>();
        Map<Joint.Id, ServoController.ServoId> ids = config.getIdMap();
        if (ids == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<Joint.Id, ServoController.ServoId> e : ids.entrySet()) {
            Joint.Id jointId = e.getKey();
            ServoController.ServoId servoId = e.getValue();
            if (jointId == null || servoId == null) {
                throw new NullPointerException();
            }
            Robot.JointId jId = new Robot.JointId(this.getRobotId(), jointId);
            this.myServoIdMap.put(jId, servoId);
        }
        for (ServoControllerContext scc : config.getControllerContexts()) {
            if (scc == null) {
                throw new NullPointerException();
            }
            ServoController controller = scc.getServoController();
            ServoJointAdapter adapter = scc.getServoJointAdapter();
            if (controller == null || adapter == null) {
                throw new NullPointerException();
            }
            ServoController.Id scId = controller.getId();
            this.myControllers.put(scId, controller);
            this.myControllerList.add(controller);
            this.myServoJointAdapters.put(scId, adapter);
        }
        this.initChangeMonitor();
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean val) {
        super.setEnabled(val);
        for (ServoController sc : this.myControllerList) {
            sc.setEnabled(val);
        }
    }

    private void initChangeMonitor() {
        this.myChangeMonitor = new PropertyChangeMonitor();
        PropertyChangeAction pca = new PropertyChangeAction(){

            protected void run(PropertyChangeEvent event) {
                ServoRobot.this.jointsChanged(event);
            }
        };
        this.myChangeMonitor.addAction("Servos", (PropertyChangeActionBase)pca);
        this.myChangeMonitor.addAction("addServo", (PropertyChangeActionBase)pca);
        this.myChangeMonitor.addAction("removeServo", (PropertyChangeActionBase)pca);
        for (ServoController c : this.myControllerList) {
            c.addPropertyChangeListener((PropertyChangeListener)this.myChangeMonitor);
        }
    }

    @Override
    public boolean connect() {
        for (ServoController controller : this.myControllerList) {
            try {
                controller.connect();
            }
            catch (Throwable t) {
                theLogger.log(Level.WARNING, "Unable to connect to ServoController.", t);
            }
        }
        this.setServos();
        boolean oldVal = this.myConnectionFlag;
        this.myConnectionFlag = true;
        this.firePropertyChange("isConnected", oldVal, this.myConnectionFlag);
        return true;
    }

    private void setServos() {
        this.clearJoints();
        this.myMissingJoints.clear();
        for (Map.Entry<Robot.JointId, ServoController.ServoId> e : this.myServoIdMap.entrySet()) {
            Robot.JointId jId = e.getKey();
            ServoController.ServoId sId = e.getValue();
            ServoController.Id scId = sId.getControllerId();
            ServoController sc = this.myControllers.get(scId);
            ServoJointAdapter sja = this.myServoJointAdapters.get(scId);
            if (sc == null || sja == null) {
                this.myMissingJoints.add(jId);
                continue;
            }
            Object s = sc.getServo(sId);
            if (s == null) {
                this.myMissingJoints.add(jId);
                continue;
            }
            Object j = sja.getJoint(jId.getJointId(), s);
            if (j == null) {
                this.myMissingJoints.add(jId);
                continue;
            }
            this.addJoint(j);
        }
        for (Robot.JointId robotJointId : this.myMissingJoints) {
            Joint.Id jointId = robotJointId.getJointId();
            String name = "Joint - " + jointId.toString();
            EmptyServoJoint j = new EmptyServoJoint(jointId, name, new NormalizedDouble(0.5));
            this.addJoint(j);
        }
    }

    @Override
    public void disconnect() {
        for (ServoController jc : this.myControllerList) {
            jc.disconnect();
        }
        boolean oldVal = this.myConnectionFlag;
        this.myConnectionFlag = false;
        this.firePropertyChange("isConnected", oldVal, this.myConnectionFlag);
    }

    @Override
    public boolean isConnected() {
        return this.myConnectionFlag;
    }

    @Override
    public void move(Robot.RobotPositionMap positions, long lenMillisec) {
        if (!this.isConnected() || !this.isEnabled()) {
            return;
        }
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        for (Map.Entry e : positions.entrySet()) {
            Robot.JointId id = (Robot.JointId)e.getKey();
            ServoJoint j = (ServoJoint)this.myJointMap.get(id);
            if (j == null) continue;
            NormalizedDouble pos = (NormalizedDouble)e.getValue();
            j.setGoalPosition(pos);
        }
        this.move(lenMillisec, positions.keySet().toArray(new Robot.JointId[0]));
    }

    private void move(long lenMillisec, Robot.JointId ... ids) {
        Map<ServoController.Id, List<ServoController.ServoId>> map = this.getServoIds(ids);
        for (Map.Entry<ServoController.Id, List<ServoController.ServoId>> e : map.entrySet()) {
            ServoController.Id scId = e.getKey();
            List<ServoController.ServoId> sIds = e.getValue();
            this.moveController(scId, sIds, lenMillisec);
        }
    }

    private void moveController(ServoController.Id controllerId, List<ServoController.ServoId> servoIds, long lenMillisec) {
        ServoController sc = this.myControllers.get(controllerId);
        if (sc == null) {
            return;
        }
        Class idType = sc.getServoIdClass();
        ServoController.ServoId[] ids = new ServoController.ServoId[servoIds.size()];
        int i = 0;
        for (ServoController.ServoId sId : servoIds) {
            Object id = sId.getServoId();
            if (!idType.isAssignableFrom(id.getClass())) continue;
            ids[i] = sId;
            ++i;
        }
        sc.moveServos(ids, i, 0, lenMillisec);
    }

    public Map<ServoController.Id, ServoController> getControllers() {
        return Collections.unmodifiableMap(this.myControllers);
    }

    public List<ServoController> getControllerList() {
        return this.myControllerList;
    }

    private Map<ServoController.Id, List<ServoController.ServoId>> getServoIds(Robot.JointId ... ids) {
        HashMap<ServoController.Id, List<ServoController.ServoId>> map = new HashMap<ServoController.Id, List<ServoController.ServoId>>();
        for (Robot.JointId jointId : ids) {
            ServoController.ServoId sId;
            if (!jointId.getRobotId().equals(this.getRobotId()) || (sId = this.myServoIdMap.get(jointId)) == null) continue;
            ArrayList<ServoController.ServoId> servoIds = (ArrayList<ServoController.ServoId>)map.get(sId.getControllerId());
            if (servoIds == null) {
                servoIds = new ArrayList<ServoController.ServoId>();
                map.put(sId.getControllerId(), servoIds);
            }
            servoIds.add(sId);
        }
        return map;
    }

    private void jointsChanged(PropertyChangeEvent event) {
        this.setServos();
    }

    public static class ServoControllerContext<T extends Servo<?, ?>> {
        private ServiceContext<ServoController<?, ?, T, ?>, ServoControllerConfig, ?> myConnectionContext;
        private ServoJointAdapter<T, ?> myServoJointAdapter;
        private boolean myInitializedFlag;

        public ServoControllerContext(ServiceContext<ServoController<?, ?, T, ?>, ServoControllerConfig, ?> connContext, ServoJointAdapter<T, ?> jointAdapter) {
            if (connContext == null || jointAdapter == null) {
                throw new NullPointerException();
            }
            this.myInitializedFlag = false;
            this.myConnectionContext = connContext;
            this.myServoJointAdapter = jointAdapter;
        }

        public void initialize() {
            if (this.myInitializedFlag) {
                return;
            }
            try {
                this.myConnectionContext.buildService();
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Unable to build Service.", ex);
                return;
            }
            ServoController controller = (ServoController)this.myConnectionContext.getService();
            if (controller == null) {
                return;
            }
            this.myInitializedFlag = true;
        }

        public ServoController getServoController() {
            if (!this.myInitializedFlag) {
                this.initialize();
            }
            return (ServoController)this.myConnectionContext.getService();
        }

        public ServoJointAdapter getServoJointAdapter() {
            return this.myServoJointAdapter;
        }
    }
}

