/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.sync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.sync.SynchronizedJointConfig;
import org.robokind.api.motion.sync.SynchronizedRobot;

class SynchronizedJoint
extends PropertyChangeNotifier
implements Joint,
PropertyChangeListener {
    private Joint.Id myJointId;
    private String myName;
    private SynchronizedRobot myRobot;
    private NormalizedDouble myDefaultPosition;
    private NormalizedDouble myGoalPosition;
    private Joint myPrimaryJoint;
    private List<Joint> myJoints;
    private boolean myEnabledFlag;

    SynchronizedJoint(SynchronizedJointConfig config, SynchronizedRobot robot) {
        this(config.getJointId(), robot, config.getName(), config.getDefaultPosition());
    }

    SynchronizedJoint(Joint.Id id, SynchronizedRobot robot) {
        this(id, robot, "Joint " + id.getLogicalJointNumber(), new NormalizedDouble(0.5));
    }

    SynchronizedJoint(Joint.Id id, SynchronizedRobot robot, String name, NormalizedDouble defPos) {
        if (id == null || robot == null || name == null) {
            throw new NullPointerException();
        }
        this.myRobot = robot;
        this.myJointId = id;
        this.myName = name;
        this.myDefaultPosition = defPos;
        if (this.myDefaultPosition == null) {
            this.myDefaultPosition = new NormalizedDouble(0.5);
        }
        this.myGoalPosition = this.myDefaultPosition;
        this.myEnabledFlag = true;
        this.myJoints = new ArrayList<Joint>();
        this.updateJointList();
    }

    final void updatePrimaryJoint() {
        Robot r;
        if (this.myPrimaryJoint != null) {
            this.myPrimaryJoint.removePropertyChangeListener(this);
        }
        if ((r = this.myRobot.getPrimaryRobot()) == null) {
            this.myPrimaryJoint = null;
            return;
        }
        Robot.JointId jId = new Robot.JointId(r.getRobotId(), this.myJointId);
        Object j = r.getJoint(jId);
        if (this.myJoints.contains(j)) {
            this.myPrimaryJoint = j;
            this.myPrimaryJoint.addPropertyChangeListener(this);
        } else {
            this.myPrimaryJoint = null;
        }
    }

    final void updateJointList() {
        List<Robot> robots = this.myRobot.getRobots();
        this.myJoints.clear();
        for (Robot r : robots) {
            Object j = r.getJoint(new Robot.JointId(r.getRobotId(), this.myJointId));
            if (j == null) continue;
            this.myJoints.add((Joint)j);
        }
        this.updatePrimaryJoint();
    }

    @Override
    public Joint.Id getId() {
        return this.myJointId;
    }

    @Override
    public String getName() {
        if (this.myPrimaryJoint != null) {
            return this.myPrimaryJoint.getName();
        }
        return this.myName;
    }

    @Override
    public NormalizedDouble getDefaultPosition() {
        if (this.myPrimaryJoint != null) {
            return this.myPrimaryJoint.getDefaultPosition();
        }
        return this.myDefaultPosition;
    }

    @Override
    public NormalizedDouble getGoalPosition() {
        if (this.myPrimaryJoint != null) {
            return this.myPrimaryJoint.getGoalPosition();
        }
        return this.myGoalPosition;
    }

    void setGoalPosition(NormalizedDouble pos) {
        this.myGoalPosition = pos;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        for (Joint j : this.myJoints) {
            j.setEnabled(enabled);
        }
        this.myEnabledFlag = enabled;
    }

    @Override
    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    @Override
    public <T> JointProperty<T> getProperty(String name, Class<T> propertyType) {
        if (this.myPrimaryJoint == null) {
            return null;
        }
        return this.myPrimaryJoint.getProperty(name, propertyType);
    }

    @Override
    public JointProperty getProperty(String name) {
        if (this.myPrimaryJoint == null) {
            return null;
        }
        return this.myPrimaryJoint.getProperty(name);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.firePropertyChange(pce);
    }
}

