/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.jointgroup;

import java.util.List;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.AbstractJointGroup;

public class RobotJointGroup
extends AbstractJointGroup<Robot.JointId, RobotJointGroup, Joint> {
    public static final String CONFIG_TYPE = "RobotJointGroup";
    public static final String CONFIG_VERSION = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("RobotJointGroup", "1.0");
    private Robot myRobot;

    public RobotJointGroup(String name, List<Robot.JointId> ids, List<RobotJointGroup> groups) {
        super(name, ids, groups);
    }

    public void setRobot(Robot robot) {
        Robot old = this.myRobot;
        this.setRobotQuite(robot);
        this.firePropertyChange("structureChanged", old, this.myRobot);
    }

    public Robot getRobot() {
        return this.myRobot;
    }

    private void setRobotQuite(Robot robot) {
        if (this.myRobot == robot) {
            return;
        }
        this.myRobot = robot;
        for (RobotJointGroup group : this.myGroups) {
            group.setRobotQuite(robot);
        }
    }

    @Override
    protected Joint getJointById(Robot.JointId jointId) {
        if (this.myRobot == null) {
            return null;
        }
        return this.myRobot.getJoint(jointId);
    }
}

