/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RobotRequestFactory;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.api.motion.protocol.RobotResponse;

public class RemoteRobotClient {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotClient.class.getName());
    public static final int DEFAULT_TIMEOUT_LENGTH = 20000;
    private Robot.Id myRobotId;
    private String mySourceId;
    private String myDestinationId;
    private RobotRequestFactory myRequestFactory;
    private MotionFrameEvent.MotionFrameEventFactory myMotionFrameAdapter;
    private MessageSender<RobotRequest> myRequestSender;
    private MessageBlockingReceiver<RobotResponse> myResponseReceiver;
    private MessageSender<MotionFrameEvent> myMotionFrameSender;

    public RemoteRobotClient(Robot.Id robotId, String sourceId, String destId, RobotRequestFactory reqFact, MotionFrameEvent.MotionFrameEventFactory motionFrameEventFactory) {
        if (robotId == null || sourceId == null || destId == null || reqFact == null || motionFrameEventFactory == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.mySourceId = sourceId;
        this.myDestinationId = destId;
        this.myRequestFactory = reqFact;
        this.myMotionFrameAdapter = motionFrameEventFactory;
    }

    public void setRequestSender(MessageSender<RobotRequest> reqSender) {
        if (reqSender == null) {
            throw new NullPointerException();
        }
        this.myRequestSender = reqSender;
    }

    public void setResponseReceiver(MessageBlockingReceiver<RobotResponse> respRec) {
        if (respRec == null) {
            throw new NullPointerException();
        }
        this.myResponseReceiver = respRec;
    }

    public void setMotionFrameSender(MessageSender<MotionFrameEvent> frameSender) {
        if (frameSender == null) {
            throw new NullPointerException();
        }
        this.myMotionFrameSender = frameSender;
    }

    public Robot.Id getRobotId() {
        return this.myRobotId;
    }

    public String getSourceId() {
        return this.mySourceId;
    }

    public String getDestinationId() {
        return this.myDestinationId;
    }

    public RobotDefinitionResponse requestRobotDefinition() {
        return this.makeDefinitionRequest("getRobotDefinition", 20000L);
    }

    public boolean sendConnect() {
        return this.makeStatusRequest("connectRobot", 20000L);
    }

    public boolean sendDisconnect() {
        return this.makeStatusRequest("disconnectRobot", 20000L);
    }

    public boolean getConnected() {
        return this.makeStatusRequest("getConnectionStatus", 20000L);
    }

    public boolean sendEnable() {
        return this.makeStatusRequest("enableRobot", 20000L);
    }

    public boolean sendDisable() {
        return this.makeStatusRequest("disableRobot", 20000L);
    }

    public boolean getEnabled() {
        return this.makeStatusRequest("getEnabledStatus", 20000L);
    }

    public boolean sendJointEnable(Robot.JointId jointId) {
        return this.makeStatusRequestForJoint("enableJoint", jointId, 20000L);
    }

    public boolean sendJointDisable(Robot.JointId jointId) {
        return this.makeStatusRequestForJoint("disableJoint", jointId, 20000L);
    }

    public boolean getJointEnabled(Robot.JointId jointId) {
        return this.makeStatusRequestForJoint("getJointEnabledStatus", jointId, 20000L);
    }

    public Robot.RobotPositionMap requestDefaultPositions() {
        return this.makePositionRequest("getDefaultPositions", 20000L);
    }

    public Robot.RobotPositionMap requestGoalPositions() {
        return this.makePositionRequest("getGoalPositions", 20000L);
    }

    public Robot.RobotPositionMap requestCurrentPositions() {
        return this.makePositionRequest("getGoalPositions", 20000L);
    }

    public void sendMovement(MotionFrame frame) {
        MotionFrameEvent mfe = this.myMotionFrameAdapter.createMotionFrameEvent(this.mySourceId, this.myDestinationId, frame);
        this.myMotionFrameSender.notifyListeners((Object)mfe);
    }

    private Boolean makeStatusRequest(String requestType, long timeout) {
        RobotResponse.RobotStatusResponse resp = this.makeBlockingRequest(RobotResponse.RobotStatusResponse.class, requestType, timeout);
        if (resp == null) {
            theLogger.log(Level.WARNING, "Received null status for: {0}, from: {1}", new Object[]{requestType, this.myRobotId.getRobtIdString()});
            return null;
        }
        return resp.getStatusResponse();
    }

    private Boolean makeStatusRequestForJoint(String requestType, Robot.JointId jointId, long timeout) {
        RobotResponse.RobotStatusResponse resp = this.makeBlockingRequestForJoint(requestType, jointId, timeout);
        if (resp == null) {
            theLogger.log(Level.WARNING, "Received null positions for: {0}, from: {1}", new Object[]{requestType, this.myRobotId.getRobtIdString()});
            return null;
        }
        return resp.getStatusResponse();
    }

    private Robot.RobotPositionMap makePositionRequest(String requestType, long timeout) {
        RobotResponse.RobotPositionResponse resp = this.makeBlockingRequest(RobotResponse.RobotPositionResponse.class, requestType, timeout);
        if (resp == null) {
            theLogger.log(Level.WARNING, "Received null positions for: {0}, from: {1}", new Object[]{requestType, this.myRobotId.getRobtIdString()});
            return null;
        }
        return resp.getPositionMap();
    }

    private RobotDefinitionResponse makeDefinitionRequest(String requestType, long timeout) {
        RobotDefinitionResponse resp = this.makeBlockingRequest(RobotDefinitionResponse.class, requestType, timeout);
        if (resp == null) {
            theLogger.log(Level.WARNING, "Received null definition for: {0}, from: {1}", new Object[]{requestType, this.myRobotId.getRobtIdString()});
            return null;
        }
        return resp;
    }

    private synchronized <T extends RobotResponse> T makeBlockingRequest(Class<T> responseClass, String requestType, long timeout) {
        if (responseClass == null || requestType == null) {
            throw new NullPointerException();
        }
        this.myResponseReceiver.clearMessages();
        Object req = this.myRequestFactory.buildRobotRequest(this.myRobotId, this.mySourceId, this.myDestinationId, requestType, TimeUtils.now());
        this.myRequestSender.notifyListeners(req);
        return this.fetchTypedResponse(responseClass, (RobotRequest)req, timeout);
    }

    private synchronized RobotResponse.RobotStatusResponse makeBlockingRequestForJoint(String requestType, Robot.JointId jointId, long timeout) {
        if (requestType == null) {
            throw new NullPointerException();
        }
        Object req = this.myRequestFactory.buildJointRequest(jointId, this.mySourceId, this.myDestinationId, requestType, TimeUtils.now());
        this.myRequestSender.notifyListeners(req);
        return this.fetchTypedResponse((Class)RobotResponse.RobotStatusResponse.class, (RobotRequest)req, timeout);
    }

    private <T extends RobotResponse> T fetchTypedResponse(Class<T> clazz, RobotRequest request, long timeout) {
        long elapsed;
        long start = TimeUtils.now();
        do {
            RobotResponse resp;
            if ((resp = (RobotResponse)this.myResponseReceiver.getValue()) == null) {
                theLogger.warning("Received null Message from Receiver");
                continue;
            }
            if (!this.isMatch(request, resp.getResponseHeader())) {
                theLogger.warning("Response does not match Request.  Ignoring response.");
                continue;
            }
            if (!clazz.isAssignableFrom(resp.getClass())) continue;
            return (T)resp;
        } while ((timeout -= (elapsed = TimeUtils.now() - start)) > 0L);
        return null;
    }

    private boolean isMatch(RobotRequest req, RobotResponse.RobotResponseHeader resp) {
        if (req == null || resp == null) {
            throw new NullPointerException();
        }
        if (!req.getRobotId().equals(resp.getRobotId())) {
            return false;
        }
        if (!req.getRequestType().equals(resp.getRequestType())) {
            return false;
        }
        return req.getTimestampMillisecUTC() == resp.getRequestTimestampMillisecUTC();
    }
}

