/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.sync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.AbstractRobot;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.sync.SynchronizedJoint;
import org.robokind.api.motion.sync.SynchronizedJointConfig;
import org.robokind.api.motion.sync.SynchronizedRobotConfig;

public class SynchronizedRobot
extends AbstractRobot<SynchronizedJoint> {
    public static final String VERSION_NAME = "SynchronizedRobot";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("SynchronizedRobot", "1.0");
    public static final String PROP_ADD_ROBOT = "addRobot";
    public static final String PROP_REMOVE_ROBOT = "removeRobot";
    private List<Robot> myRobots = new ArrayList<Robot>();
    private Robot myPrimaryRobot;
    private RobotPropertyChangeForwarder myPropertyChangeHandler;

    public SynchronizedRobot(SynchronizedRobotConfig config) {
        super(config.getRobotId());
        for (SynchronizedJointConfig conf : config.getJointConfigs()) {
            this.addJoint(new SynchronizedJoint(conf, this));
        }
        this.myPropertyChangeHandler = new RobotPropertyChangeForwarder();
    }

    public SynchronizedRobot(Robot.Id robotId, Set<Joint.Id> jointIds) {
        super(robotId);
        for (Joint.Id jId : jointIds) {
            this.addJoint(new SynchronizedJoint(jId, this));
        }
    }

    @Override
    public boolean connect() {
        return true;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void move(Robot.RobotPositionMap positions, long lenMillisec) {
        for (Robot r : this.myRobots) {
            Robot.RobotPositionMap newPos = this.changeId(positions, r.getRobotId());
            r.move(newPos, lenMillisec);
        }
        for (Map.Entry e : positions.entrySet()) {
            Robot.JointId jId = (Robot.JointId)e.getKey();
            NormalizedDouble d = (NormalizedDouble)e.getValue();
            SynchronizedJoint j = (SynchronizedJoint)this.getJoint(jId);
            j.setGoalPosition(d);
        }
    }

    private Robot.RobotPositionMap changeId(Robot.RobotPositionMap pos, Robot.Id newId) {
        Robot.RobotPositionHashMap newPos = new Robot.RobotPositionHashMap(pos.size());
        for (Map.Entry e : pos.entrySet()) {
            Robot.JointId oldJId = (Robot.JointId)e.getKey();
            if (!this.myJointMap.containsKey(oldJId)) continue;
            Robot.JointId jId = new Robot.JointId(newId, oldJId.getJointId());
            newPos.put(jId, e.getValue());
        }
        return newPos;
    }

    public Robot getPrimaryRobot() {
        return this.myPrimaryRobot;
    }

    public List<Robot> getRobots() {
        return this.myRobots;
    }

    public void addRobot(Robot robot) {
        if (robot == null) {
            throw new NullPointerException();
        }
        if (robot instanceof SynchronizedRobot) {
            throw new IllegalArgumentException("Cannot add SynchronizedRobot.");
        }
        if (!this.myRobots.contains(robot)) {
            return;
        }
        this.myRobots.add(robot);
        this.updateJoints();
        this.firePropertyChange(PROP_ADD_ROBOT, null, robot);
    }

    public void removeRobot(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        Object remove = null;
        for (Robot r : this.myRobots) {
            if (!robotId.equals(r.getRobotId())) continue;
            remove = r;
        }
        if (remove == null) {
            return;
        }
        if (remove.equals(this.myPrimaryRobot)) {
            this.myPrimaryRobot = null;
        }
        this.myRobots.remove(remove);
        this.updateJoints();
        this.firePropertyChange(PROP_REMOVE_ROBOT, null, remove);
    }

    public void setPrimaryRobot(Robot.Id robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        for (Robot r : this.myRobots) {
            if (!robotId.equals(r.getRobotId())) continue;
            this.myPrimaryRobot = r;
            this.updatePrimaryJoints();
            this.myPropertyChangeHandler.setRobot(this.myPrimaryRobot);
            return;
        }
    }

    private void updateJoints() {
        for (SynchronizedJoint j : this.myJointList) {
            j.updateJointList();
        }
    }

    private void updatePrimaryJoints() {
        for (SynchronizedJoint j : this.myJointList) {
            j.updatePrimaryJoint();
        }
    }

    class RobotPropertyChangeForwarder
    implements PropertyChangeListener {
        private Robot myRobot;

        RobotPropertyChangeForwarder() {
        }

        public void setRobot(Robot robot) {
            if (this.myRobot != null) {
                this.myRobot.removePropertyChangeListener(this);
            }
            this.myRobot = robot;
            if (this.myRobot != null) {
                this.myRobot.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SynchronizedRobot.this.firePropertyChange(evt);
        }
    }
}

