/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.Blender;
import org.robokind.api.motion.blending.FrameSourceTracker;
import org.robokind.api.motion.blending.TimedBlenderDriver;

public class TimedBlenderDriverLifecycle
extends AbstractLifecycleProvider<TimedBlenderDriver, TimedBlenderDriver> {
    private static final String theBlender = "blender";
    private static final String theFrameTracker = "frameTracker";
    private long myBlenderInterval;

    public TimedBlenderDriverLifecycle(Robot.Id robotId, long blenderIntervalMillisec) {
        super(new DescriptorListBuilder().dependency(theBlender, Blender.class).with("robotId", robotId.getRobtIdString()).with("positionMapType", Robot.RobotPositionMap.class.getName()).dependency(theFrameTracker, FrameSourceTracker.class).with("robotId", robotId.getRobtIdString()).with("positionMapType", Robot.RobotPositionMap.class.getName()).getDescriptors());
        this.myBlenderInterval = blenderIntervalMillisec;
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
    }

    protected TimedBlenderDriver create(Map<String, Object> services) {
        Blender blender = (Blender)services.get(theBlender);
        FrameSourceTracker tracker = (FrameSourceTracker)services.get(theFrameTracker);
        TimedBlenderDriver driver = new TimedBlenderDriver(this.myBlenderInterval);
        driver.setBlender(blender);
        driver.setFrameSourceTracker(tracker);
        driver.start();
        return driver;
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (theBlender.equals(serviceId)) {
            ((TimedBlenderDriver)((Object)this.myService)).setBlender((Blender)service);
        } else if (theFrameTracker.equals(serviceId)) {
            ((TimedBlenderDriver)((Object)this.myService)).setFrameSourceTracker((FrameSourceTracker)service);
        }
    }

    public Class<TimedBlenderDriver> getServiceClass() {
        return TimedBlenderDriver.class;
    }
}

