/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.messaging;

import java.util.Map;
import java.util.logging.Logger;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.AbstractRobot;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteJoint;
import org.robokind.api.motion.messaging.RemoteRobotClient;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;

public class RemoteRobot
extends AbstractRobot<RemoteJoint> {
    private static final Logger theLogger = Logger.getLogger(RemoteRobot.class.getName());
    private RemoteRobotClient myRobotClient;
    private Robot.RobotPositionMap myPreviousPositions;

    public RemoteRobot(RemoteRobotClient client) {
        super(client.getRobotId());
        this.myRobotClient = client;
        this.updateRobotDefinition();
    }

    private void updateRobotDefinition() {
        RobotDefinitionResponse robotDef = this.myRobotClient.requestRobotDefinition();
        if (robotDef == null) {
            theLogger.warning("RobotRequest timed out.  Unable to update definition.");
            throw new NullPointerException();
        }
        for (RobotDefinitionResponse.JointDefinition def : robotDef.getJointDefinitions()) {
            RemoteJoint rj = new RemoteJoint(this, def);
            this.addJoint(rj);
        }
    }

    public boolean updateRobot() {
        try {
            this.updateRobotDefinition();
        }
        catch (NullPointerException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean connect() {
        Boolean ret = this.myRobotClient.sendConnect();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to connect.");
            return false;
        }
        return ret;
    }

    @Override
    public void disconnect() {
        Boolean ret = this.myRobotClient.sendDisconnect();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to disconnect.");
        }
    }

    @Override
    public boolean isConnected() {
        Boolean ret = this.myRobotClient.getConnected();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get connection status.");
            return false;
        }
        return ret;
    }

    @Override
    public void setEnabled(boolean val) {
        Boolean ret = val ? this.myRobotClient.sendEnable() : this.myRobotClient.sendDisable();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to set enabled value.");
        }
    }

    @Override
    public boolean isEnabled() {
        Boolean ret = this.myRobotClient.getEnabled();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get enabled status.");
            return false;
        }
        return ret;
    }

    boolean setJointEnabled(Robot.JointId jId, boolean val) {
        Boolean ret = val ? this.myRobotClient.sendJointEnable(jId) : this.myRobotClient.sendJointDisable(jId);
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get joint enabled confirmation.");
            return false;
        }
        return ret;
    }

    boolean getJointEnabled(Robot.JointId jId) {
        Boolean ret = this.myRobotClient.getJointEnabled(jId);
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get joint enabled status.");
        }
        return ret;
    }

    @Override
    public void move(Robot.RobotPositionMap positions, long lenMillisec) {
        DefaultMotionFrame<Robot.RobotPositionMap> frame = new DefaultMotionFrame<Robot.RobotPositionMap>();
        frame.setFrameLengthMillisec(lenMillisec);
        frame.setGoalPositions(positions);
        frame.setPreviousPositions(this.myPreviousPositions);
        frame.setTimestampMillisecUTC(TimeUtils.now());
        this.myRobotClient.sendMovement(frame);
        this.myPreviousPositions = positions;
        this.setGoals(this.myPreviousPositions);
    }

    private void setGoals(Robot.RobotPositionMap goals) {
        for (Map.Entry e : goals.entrySet()) {
            Robot.JointId jId = (Robot.JointId)e.getKey();
            NormalizedDouble val = (NormalizedDouble)e.getValue();
            RemoteJoint j = (RemoteJoint)this.getJoint(jId);
            if (j == null) continue;
            j.setGoalPosition(val);
        }
    }
}

