/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.servos.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.ServoRobot;

public class ServoRobotConfig {
    private static final Logger theLogger = Logger.getLogger(ServoRobotConfig.class.getName());
    private Robot.Id myRobotId;
    private Map<Joint.Id, ServoController.ServoId> myIdMap = new HashMap<Joint.Id, ServoController.ServoId>();
    private List<ServoRobot.ServoControllerContext> myControllerContexts = new ArrayList<ServoRobot.ServoControllerContext>();

    public Robot.Id getRobotId() {
        return this.myRobotId;
    }

    public void setRobotId(Robot.Id robotId) {
        this.myRobotId = robotId;
    }

    public void addServoJoint(Joint.Id id, ServoController.ServoId servoId) {
        if (this.myIdMap.containsKey(id)) {
            theLogger.log(Level.WARNING, "Unable to add entry (jointId={0}, servoId={1}).  JointId already exists.", new Object[]{id, servoId});
        }
        this.myIdMap.put(id, servoId);
    }

    public Map<Joint.Id, ServoController.ServoId> getIdMap() {
        return this.myIdMap;
    }

    public void addControllerContext(ServoRobot.ServoControllerContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myControllerContexts.add(context);
    }

    public List<ServoRobot.ServoControllerContext> getControllerContexts() {
        return Collections.unmodifiableList(this.myControllerContexts);
    }
}

