/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.PositionTargetFrameSource;
import org.robokind.api.motion.utils.RobotManager;

public class RobotController
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String PROP_ROBOT = "robot";
    private Robot myRobot;
    private PositionTargetFrameSource myRobotMover;
    private RobotManager myManager;

    public RobotController(RobotManager manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.myManager = manager;
    }

    public void setRobot(Robot robot) {
        Robot oldVal = this.getRobot();
        this.unsetRobot();
        this.myRobot = robot;
        if (this.myRobotMover != null) {
            this.myRobotMover.setRobot(this.myRobot);
        }
        if (this.myRobot != null) {
            this.myRobot.addPropertyChangeListener(this);
        }
        this.firePropertyChange(PROP_ROBOT, oldVal, this.myRobot);
    }

    private void unsetRobot() {
        Robot r = this.getRobot();
        if (r != null) {
            r.removePropertyChangeListener(this);
        }
        if (this.myRobotMover != null) {
            this.myRobotMover.setRobot(null);
        }
    }

    public Robot getRobot() {
        return this.myRobot;
    }

    public boolean connectRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (r.isConnected()) {
            return true;
        }
        return r.connect();
    }

    public boolean disconnectRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (!r.isConnected()) {
            return true;
        }
        r.disconnect();
        return !r.isConnected();
    }

    public boolean enableRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (r.isEnabled()) {
            return true;
        }
        r.setEnabled(true);
        return true;
    }

    public boolean disableRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        if (!r.isEnabled()) {
            return true;
        }
        r.setEnabled(false);
        return true;
    }

    public boolean selectRobot() {
        Robot r = this.getRobot();
        if (r == null) {
            return false;
        }
        return false;
    }

    public boolean setDefaultPositions() {
        Robot r = this.getRobot();
        if (r == null || this.myRobotMover == null) {
            return false;
        }
        Robot.RobotPositionMap defPos = r.getDefaultPositions();
        this.myRobotMover.putPositions(defPos);
        return true;
    }

    public boolean removeRobot() {
        this.unsetRobot();
        return true;
    }

    public void setRobotMover(PositionTargetFrameSource mover) {
        this.myRobotMover = mover;
        if (this.myRobotMover != null && this.myRobotMover.getRobot() != this.myRobot) {
            this.myRobotMover.setRobot(this.myRobot);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }
}

