/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.servos.config;

import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceParams;
import org.robokind.api.motion.servos.ServoController;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class ServoControllerContext<Param> {
    private ConfiguredServiceParams<ServoController,?,Param> myServiceParams;
    
    public ServoControllerContext(Class<Param> paramClass, Param param,
            VersionProperty controllerVersion, VersionProperty configFormat){
        if(paramClass == null || param == null || 
                controllerVersion == null || configFormat == null){
            throw new NullPointerException();
        }
        myServiceParams = new ConfiguredServiceParams(
                ServoController.class, null, paramClass, 
                null, param, null, controllerVersion, configFormat);
    }
}
