/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobot;
import org.robokind.api.motion.messaging.RemoteRobotClient;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class RemoteRobotLifecycle extends 
        AbstractLifecycleProvider<Robot, RemoteRobot>{
    private final static Logger theLogger = 
            Logger.getLogger(RemoteRobotLifecycle.class.getName());
    private final static String theRobotClient = "remoteRobotClient";

    public RemoteRobotLifecycle(Robot.Id robotId){
        super(new DescriptorListBuilder()
                .dependency(theRobotClient, RemoteRobotClient.class)
                    .with(Robot.PROP_ID, robotId.getRobtIdString())
                .getDescriptors());
        if(robotId == null){
            throw new NullPointerException();
        }
        if(myRegistrationProperties == null){
            myRegistrationProperties = new Properties();
        }
        myRegistrationProperties.put(Robot.PROP_ID, robotId.getRobtIdString());
        myServiceClassNames = new String[]{
            Robot.class.getName(), RemoteRobot.class.getName()
        };
    }

    @Override
    protected RemoteRobot create(Map<String, Object> services) {
        RemoteRobotClient client = 
                (RemoteRobotClient)services.get(theRobotClient);
        try{
            return new RemoteRobot(client);
        }catch(Exception ex){
            theLogger.log(Level.WARNING, "Error starting RemoteRobot "
                    + "messaging components.", ex);
        }
        return null;
    }

    @Override
    protected void handleChange(
            String serviceId, Object service, Map<String,Object> dependencies) {
        if(myService == null){
            return;
        }
        if(theRobotClient.equals(serviceId)){
            if(service != null){
                myService = create(dependencies);
            }else{
                myService = null;
            }
        }
    }

    @Override
    public Class<Robot> getServiceClass() {
        return Robot.class;
    }
}
