/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.servos;

import java.util.List;
import java.util.Set;
import org.jflux.impl.services.rk.utils.HashCodeUtil;
import org.jflux.impl.services.rk.utils.LocalIdentifier;
import org.robokind.api.common.property.PropertyChangeSource;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.config.ServoControllerConfig;
import org.robokind.api.motion.servos.utils.ConnectionStatus;

public interface ServoController<IdType, ServoConf extends ServoConfig<IdType>, ServoType extends Servo<IdType, ServoConf>, ControllerConf extends ServoControllerConfig<IdType, ServoConf>>
extends PropertyChangeSource {
    public static final String PROP_VERSION = "servoControllerVersion";
    public static final String PROP_CONNECTION_STATUS = "connectionStatus";
    public static final String PROP_ERROR_MESSAGES = "errorMessages";
    public static final String PROP_SERVO_ADD = "addServo";
    public static final String PROP_SERVO_REMOVE = "removeServo";
    public static final String PROP_SERVOS = "Servos";
    public static final String PROP_ENABLED = "enabled";

    public Id getId();

    public List<ServoType> getServos();

    public ServoType getServo(ServoId<IdType> var1);

    public boolean containsIds(Set<ServoId<IdType>> var1);

    public boolean containsId(ServoId<IdType> var1);

    public boolean connect();

    public boolean disconnect();

    public boolean moveServo(ServoId<IdType> var1, long var2);

    public boolean moveServos(ServoId<IdType>[] var1, int var2, int var3, long var4);

    public boolean moveAllServos(long var1);

    public ConnectionStatus getConnectionStatus();

    public List<String> getErrorMessages();

    public ControllerConf getConfig();

    public void setEnabled(Boolean var1);

    public Boolean getEnabled();

    public Class<IdType> getServoIdClass();

    public static class ServoId<ServoIdType>
    implements LocalIdentifier {
        private Id myControllerId;
        private ServoIdType myServoId;
        private int myHashCode;

        public ServoId(Id controllerId, ServoIdType servoId) {
            if (controllerId == null || servoId == null) {
                throw new NullPointerException();
            }
            this.myControllerId = controllerId;
            this.myServoId = servoId;
        }

        public final ServoIdType getServoId() {
            return this.myServoId;
        }

        public final Id getControllerId() {
            return this.myControllerId;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ServoId id = (ServoId)obj;
            return this.myControllerId.equals(id.myControllerId) && this.myServoId.equals(id.myServoId);
        }

        public int hashCode() {
            if (this.myHashCode == 0) {
                this.myHashCode = HashCodeUtil.hash((int)23, (Object[])new Object[]{this.myControllerId, this.myServoId});
            }
            return this.myHashCode;
        }

        public String toString() {
            return this.myControllerId.toString() + "::" + this.myServoId.toString();
        }
    }

    public static class Id
    implements LocalIdentifier {
        private String myControllerId;
        private int myHashCode;

        public Id(String servoControllerId) {
            if (servoControllerId == null) {
                throw new NullPointerException();
            }
            if (servoControllerId.isEmpty()) {
                throw new NullPointerException("ServoController.Id cannot be empty.");
            }
            this.myControllerId = servoControllerId;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Id id = (Id)obj;
            return this.myControllerId.equals(id.myControllerId);
        }

        public int hashCode() {
            if (this.myHashCode == 0) {
                this.myHashCode = HashCodeUtil.hash((int)23, (Object)this.myControllerId);
            }
            return this.myHashCode;
        }

        public String toString() {
            return this.myControllerId;
        }
    }
}

