/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.messaging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robokind.api.common.position.DoubleRange;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteJointProperty;
import org.robokind.api.motion.messaging.RemoteRobot;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;

public class RemoteJoint
extends PropertyChangeNotifier
implements Joint {
    private Joint.Id myJointId;
    private Robot.JointId myRobotJointId;
    private String myName;
    private NormalizedDouble myDefaultPosition;
    private NormalizedDouble myCachedGoalPosition;
    private Boolean myEnabledFlag;
    private RemoteRobot myRobot;
    private NormalizableRange<Double> myRange;
    Map<String, JointProperty> myProperties;

    public RemoteJoint(RemoteRobot robot, RobotDefinitionResponse.JointDefinition def) {
        if (robot == null || def == null) {
            throw new NullPointerException();
        }
        this.myRobot = robot;
        this.myJointId = def.getJointId();
        this.myRobotJointId = new Robot.JointId(this.myRobot.getRobotId(), this.myJointId);
        this.myName = def.getName();
        this.myDefaultPosition = def.getDefaultPosition();
        this.myCachedGoalPosition = def.getGoalPosition();
        this.myEnabledFlag = def.getEnabled();
        this.myRange = new DoubleRange(0.0, 1.0);
        this.myProperties = new HashMap<String, JointProperty>();
        for (RobotDefinitionResponse.JointPropDefinition p : def.getJointProperties()) {
            RemoteJointProperty<Double> prop = new RemoteJointProperty<Double>(p.getPropertyName(), p.getDisplayName(), Double.class, p.getInitialValue(), (NormalizableRange<Double>)new DoubleRange(p.getMinValue().doubleValue(), p.getMaxValue().doubleValue()));
            this.myProperties.put(p.getPropertyName(), prop);
        }
    }

    @Override
    public Joint.Id getId() {
        return this.myJointId;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosition;
    }

    protected void setGoalPosition(NormalizedDouble goal) {
        NormalizedDouble old = this.myCachedGoalPosition;
        this.myCachedGoalPosition = goal;
        this.firePropertyChange("goalPosition", old, goal);
    }

    @Override
    public NormalizedDouble getGoalPosition() {
        return this.myCachedGoalPosition;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        Boolean old = this.myEnabledFlag;
        if (!this.myRobot.setJointEnabled(this.myRobotJointId, enabled)) {
            return;
        }
        this.myEnabledFlag = enabled;
        this.firePropertyChange("enabled", old, this.myEnabledFlag);
    }

    @Override
    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public Boolean updateEnabledStatus() {
        Boolean enabled = this.myRobot.getJointEnabled(this.myRobotJointId);
        if (enabled == null) {
            return false;
        }
        Boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        this.firePropertyChange("enabled", old, this.myEnabledFlag);
        return true;
    }

    @Override
    public <T> JointProperty<T> getProperty(String name, Class<T> propertyType) {
        if (propertyType != Double.class) {
            return null;
        }
        return this.getProperty(name);
    }

    @Override
    public JointProperty getProperty(String name) {
        return this.myProperties.get(name);
    }

    @Override
    public NormalizableRange<Double> getPositionRange() {
        return this.myRange;
    }

    @Override
    public Collection<JointProperty> getProperties() {
        return this.myProperties.values();
    }
}

