/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.motion.servos.utils;

import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.ServoController.ServoId;

/**
 * A ServoIdReader is used to parse a String into a specific Id Type.
 * @param <Id> Id Type to read
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface ServoIdReader<Id>{
    /**
     * Reads and parses a String into the Id Type, and returns a 
     * ServoController.ServoId.
     * @param controllerId ServoController.Id to use
     * @param servoIdStr Id String to parse
     * @return ServoController.ServoId with the given ServoController.Id and 
     * the parsed Servo Id
     */
    public ServoId<Id> read(ServoController.Id controllerId, String servoIdStr);
    
    /**
     * Reads and parses a String into the Id Type
     * @param servoIdStr Id String to parse
     * @return parsed Servo Id
     */
    public Id read(String servoIdStr);

    /**
     * Returns the Class of the Id Type read by this ServoIdReader.
     * @return Class of the Id Type read by this ServoIdReader
     */
    public Class<Id> getServoIdClass();
}
