/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.messaging.rk.MessageBlockingReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobotClient;
import org.robokind.api.motion.messaging.RobotRequestFactory;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.api.motion.protocol.RobotResponse;

public class RemoteRobotClientLifecycle
extends AbstractLifecycleProvider<RemoteRobotClient, RemoteRobotClient> {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotClientLifecycle.class.getName());
    private static final String theFrameEventFactory = "motionFrameEventFactory";
    private static final String theRequestSender = "requestSender";
    private static final String theResponseReceiver = "responseReceiver";
    private static final String theFrameSender = "frameSender";
    private static final String theRequestFactory = "responseFactory";
    private Robot.Id myRobotId;
    private String mySourceId;
    private String myDestId;

    public RemoteRobotClientLifecycle(String sourceId, String destId, Robot.Id robotId, String reqSenderId, String respReceiverId, String frameSenderId) {
        super(new DescriptorListBuilder().dependency(theRequestSender, MessageSender.class).with("messageSenderId", reqSenderId).with("messageType", RobotRequest.class.getName()).dependency(theResponseReceiver, MessageBlockingReceiver.class).with("messageReceiverId", respReceiverId).with("messageType", RobotResponse.class.getName()).dependency(theFrameSender, MessageSender.class).with("messageSenderId", frameSenderId).with("messageType", MotionFrameEvent.class.getName()).dependency(theRequestFactory, RobotRequestFactory.class).dependency(theFrameEventFactory, MotionFrameEvent.MotionFrameEventFactory.class).getDescriptors());
        if (sourceId == null || destId == null || robotId == null) {
            throw new NullPointerException();
        }
        this.mySourceId = sourceId;
        this.myDestId = destId;
        this.myRobotId = robotId;
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
    }

    protected RemoteRobotClient create(Map<String, Object> services) {
        MessageSender reqSender = (MessageSender)services.get(theRequestSender);
        MessageBlockingReceiver respReceiver = (MessageBlockingReceiver)services.get(theResponseReceiver);
        MessageSender frameSender = (MessageSender)services.get(theFrameSender);
        RobotRequestFactory reqFact = (RobotRequestFactory)services.get(theRequestFactory);
        MotionFrameEvent.MotionFrameEventFactory frameEventFact = (MotionFrameEvent.MotionFrameEventFactory)services.get(theFrameEventFactory);
        RemoteRobotClient client = new RemoteRobotClient(this.myRobotId, this.mySourceId, this.myDestId, reqFact, frameEventFact);
        client.setMotionFrameSender((MessageSender<MotionFrameEvent>)frameSender);
        client.setRequestSender((MessageSender<RobotRequest>)reqSender);
        client.setResponseReceiver((MessageBlockingReceiver<RobotResponse>)respReceiver);
        try {
            reqSender.start();
            respReceiver.start();
            frameSender.start();
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error starting RemoteRobotHost messaging components.", ex);
        }
        return client;
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            return;
        }
        if (theResponseReceiver.equals(serviceId)) {
            ((RemoteRobotClient)this.myService).setResponseReceiver((MessageBlockingReceiver<RobotResponse>)((MessageBlockingReceiver)service));
        } else if (theRequestSender.equals(serviceId)) {
            ((RemoteRobotClient)this.myService).setRequestSender((MessageSender<RobotRequest>)((MessageSender)service));
        } else if (theFrameSender.equals(serviceId)) {
            ((RemoteRobotClient)this.myService).setMotionFrameSender((MessageSender<MotionFrameEvent>)((MessageSender)service));
        } else if (theFrameEventFactory.equals(serviceId) || theRequestFactory.equals(serviceId)) {
            // empty if block
        }
    }

    public Class<RemoteRobotClient> getServiceClass() {
        return RemoteRobotClient.class;
    }
}

