/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.motion.servos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.property.PropertyChangeAction;
import org.robokind.api.common.property.PropertyChangeActionBase;
import org.robokind.api.common.property.PropertyChangeMonitor;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.config.ServoControllerConfig;
import org.robokind.api.motion.servos.utils.ConnectionStatus;

public abstract class AbstractServoController<IdType, ServoConf extends ServoConfig<IdType>, S extends Servo<IdType, ServoConf>, ControllerConf extends ServoControllerConfig<IdType, ServoConf>>
extends PropertyChangeNotifier
implements ServoController<IdType, ServoConf, S, ControllerConf> {
    private static final Logger theLogger = Logger.getLogger(AbstractServoController.class.getName());
    private ServoController.Id myServoControllerId;
    protected ControllerConf myConfig;
    protected List<S> myServos;
    protected Map<ServoController.ServoId<IdType>, S> myServoMap;
    protected ConnectionStatus myConnectionStatus;
    protected PropertyChangeMonitor myChangeMonitor;

    public AbstractServoController(ControllerConf config) {
        if (config == null) {
            throw new NullPointerException();
        }
        ServoController.Id id = config.getServoControllerId();
        if (id == null) {
            throw new NullPointerException();
        }
        this.myServoControllerId = id;
        this.initPropertyChangeMontior();
        this.myConfig = config;
        this.myConfig.addPropertyChangeListener((PropertyChangeListener)this.myChangeMonitor);
        for (ServoConfig sc : this.myConfig.getServoConfigs().values()) {
            sc.addPropertyChangeListener((PropertyChangeListener)this.myChangeMonitor);
        }
        this.myConnectionStatus = ConnectionStatus.DISCONNECTED;
        this.myServoMap = new HashMap<ServoController.ServoId<IdType>, S>();
        this.myServos = new ArrayList<S>();
    }

    private void initPropertyChangeMontior() {
        this.myChangeMonitor = new PropertyChangeMonitor();
        this.myChangeMonitor.addAction("addServo", (PropertyChangeActionBase)new PropertyChangeAction(){

            protected void run(PropertyChangeEvent event) {
                ServoConfig config = (ServoConfig)event.getNewValue();
                AbstractServoController.this.addingServo(config);
            }
        });
        this.myChangeMonitor.addAction("removeServo", (PropertyChangeActionBase)new PropertyChangeAction(){

            protected void run(PropertyChangeEvent event) {
                ServoConfig config = (ServoConfig)event.getNewValue();
                AbstractServoController.this.removingServo(AbstractServoController.this.servoId(config.getServoId()));
            }
        });
        this.myChangeMonitor.addAction("logicalId", (PropertyChangeActionBase)new PropertyChangeAction(){

            protected void run(PropertyChangeEvent event) {
                AbstractServoController.this.changeServoId((ServoController.ServoId)event.getOldValue(), (ServoController.ServoId)event.getNewValue());
            }
        });
    }

    @Override
    public final ServoController.Id getId() {
        return this.myServoControllerId;
    }

    protected abstract S connectServo(ServoConf var1);

    protected abstract boolean disconnectServo(ServoController.ServoId<IdType> var1);

    public void addServo(ServoConf config) {
        this.myConfig.addServoConfig(config);
    }

    public void removeServo(S servo) {
        this.myConfig.removeServoConfig(servo.getConfig());
    }

    protected void setConnectStatus(ConnectionStatus status) {
        ConnectionStatus oldStatus = this.myConnectionStatus;
        this.myConnectionStatus = status;
        this.firePropertyChange("connectionStatus", (Object)oldStatus, (Object)status);
    }

    @Override
    public S getServo(ServoController.ServoId<IdType> id) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Must be connected to access Servos");
            return null;
        }
        Servo Servo2 = (Servo)this.myServoMap.get(id);
        return (S)Servo2;
    }

    @Override
    public List<S> getServos() {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Must be connected to access Servos");
            return Collections.EMPTY_LIST;
        }
        return this.myServos;
    }

    @Override
    public boolean containsIds(Set<ServoController.ServoId<IdType>> ids) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Must be connected to access Servos");
            return false;
        }
        return this.myServoMap.keySet().containsAll(ids);
    }

    @Override
    public boolean containsId(ServoController.ServoId<IdType> id) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Must be connected to access Servos");
            return false;
        }
        return this.myServoMap.containsKey(id);
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this.myConnectionStatus;
    }

    protected void addingServo(ServoConf config) {
        S servo = this.connectServo(config);
        if (servo == null) {
            return;
        }
        this.myServos.add(servo);
        this.myServoMap.put(this.servoId(servo.getId()), servo);
        servo.getConfig().addPropertyChangeListener((PropertyChangeListener)this.myChangeMonitor);
        this.firePropertyChange("addServo", null, servo);
    }

    protected void removingServo(ServoController.ServoId<IdType> id) {
        if (!this.disconnectServo(id)) {
            return;
        }
        Servo servo = (Servo)this.myServoMap.remove(id);
        this.myServos.remove(servo);
        servo.getConfig().removePropertyChangeListener((PropertyChangeListener)this.myChangeMonitor);
        this.firePropertyChange("removeServo", null, servo);
    }

    protected void changeServoId(ServoController.ServoId<IdType> oldId, ServoController.ServoId<IdType> newId) {
        Servo servo = (Servo)this.myServoMap.remove(oldId);
        this.myServoMap.put(newId, servo);
        this.firePropertyChange("Servos", null, this.myServoMap);
    }

    @Override
    public ControllerConf getConfig() {
        return this.myConfig;
    }

    protected ServoController.ServoId<IdType> servoId(IdType id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return new ServoController.ServoId<IdType>(this.myServoControllerId, id);
    }
}

