/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.sensor.gpio;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.Source;
import org.jflux.api.core.util.DefaultNotifier;
import org.robokind.api.sensor.DeviceBoolEvent;
import org.robokind.api.sensor.SensorEventHeader;
import org.robokind.api.sensor.gpio.GpioService;

public class RemoteGpioService<T extends SensorEventHeader>
extends DefaultNotifier<DeviceBoolEvent<T>>
implements GpioService<T> {
    private static final Logger theLogger = Logger.getLogger(RemoteGpioService.class.getName());
    private Source<T> myHeaderFactory;
    private Source<Long> myTimestampFactory;
    private Source<? extends DeviceBoolEvent<T>> myBoolEventFactory;
    private Notifier<DeviceBoolEvent<T>> myDirectionSender;
    private Notifier<DeviceBoolEvent<T>> myOutputValueSender;
    private Notifier<DeviceBoolEvent<T>> myInputValueReceiver;
    private Map<Integer, GpioPin> myPins;
    private GpioValueListener myValueListener;
    private int myDirectionSequenceId;
    private int myDirectionFrameId;
    private int myOutputValueSequenceId;
    private int myOutputValueFrameId;
    private int myInputValueSequenceId;

    public RemoteGpioService(Source<T> headerFactory, Source<Long> timestampFactory, Source<? extends DeviceBoolEvent<T>> eventFactory, Notifier<DeviceBoolEvent<T>> directionSender, Notifier<DeviceBoolEvent<T>> outputValueSender, Notifier<DeviceBoolEvent<T>> inputValueReceiver, int dirSeqId, int outValSeqId, int inValSeqId, int ... availablePins) {
        this.myHeaderFactory = headerFactory;
        this.myTimestampFactory = timestampFactory;
        this.myBoolEventFactory = eventFactory;
        this.myDirectionSender = directionSender;
        this.myOutputValueSender = outputValueSender;
        this.myInputValueReceiver = inputValueReceiver;
        this.myDirectionSequenceId = dirSeqId;
        this.myDirectionFrameId = 0;
        this.myOutputValueSequenceId = outValSeqId;
        this.myOutputValueFrameId = 0;
        this.myInputValueSequenceId = inValSeqId;
        this.myPins = new HashMap<Integer, GpioPin>(availablePins.length);
        for (int i : availablePins) {
            GpioPin pin = new GpioPin(i, false, false);
            this.myPins.put(i, pin);
        }
        this.myValueListener = new GpioValueListener();
        this.myInputValueReceiver.addListener((Listener)this.myValueListener);
    }

    @Override
    public Boolean getPinDirection(int channel) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null) {
            return null;
        }
        return pin.direction;
    }

    @Override
    public void setPinDirection(int channel, boolean direction) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null || this.myHeaderFactory == null || this.myTimestampFactory == null || this.myBoolEventFactory == null || this.myDirectionSender == null) {
            return;
        }
        SensorEventHeader header = (SensorEventHeader)this.myHeaderFactory.getValue();
        header.setFrameId(this.myDirectionFrameId++);
        header.setSequenceId(this.myDirectionSequenceId);
        header.setTimestamp((Long)this.myTimestampFactory.getValue());
        DeviceBoolEvent event = (DeviceBoolEvent)this.myBoolEventFactory.getValue();
        event.setHeader(header);
        event.setChannelId(channel);
        event.setBoolValue(direction);
        this.myDirectionSender.notifyListeners((Object)event);
        pin.direction = direction;
    }

    @Override
    public Boolean getPinValue(int channel) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null) {
            return null;
        }
        return pin.value;
    }

    @Override
    public void setPinValue(int channel, boolean val) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null || this.myHeaderFactory == null || this.myTimestampFactory == null || this.myBoolEventFactory == null || this.myOutputValueSender == null) {
            return;
        }
        if (pin.direction.booleanValue()) {
            theLogger.log(Level.WARNING, "Unable to set pin value for channel {0}, direction must be set OUT.", channel);
            return;
        }
        SensorEventHeader header = (SensorEventHeader)this.myHeaderFactory.getValue();
        header.setFrameId(this.myOutputValueFrameId++);
        header.setSequenceId(this.myOutputValueSequenceId);
        header.setTimestamp((Long)this.myTimestampFactory.getValue());
        DeviceBoolEvent event = (DeviceBoolEvent)this.myBoolEventFactory.getValue();
        event.setHeader(header);
        event.setChannelId(channel);
        event.setBoolValue(val);
        this.myOutputValueSender.notifyListeners((Object)event);
        pin.value = val;
    }

    public void setHeaderFactory(Source<T> headerFactory) {
        this.myHeaderFactory = headerFactory;
    }

    public void setTimestampFactory(Source<Long> timestampFactory) {
        this.myTimestampFactory = timestampFactory;
    }

    public void setEventFactory(Source<DeviceBoolEvent<T>> eventFactory) {
        this.myBoolEventFactory = eventFactory;
    }

    public void setDirectionSender(Notifier<DeviceBoolEvent<T>> sender) {
        this.myDirectionSender = sender;
    }

    public void setOutputValueSender(Notifier<DeviceBoolEvent<T>> sender) {
        this.myOutputValueSender = sender;
    }

    public void setInputValueReceiver(Notifier<DeviceBoolEvent<T>> receiver) {
        if (this.myInputValueReceiver != null) {
            this.myInputValueReceiver.removeListener((Listener)this.myValueListener);
        }
        this.myInputValueReceiver = receiver;
        if (this.myInputValueReceiver != null) {
            this.myInputValueReceiver.addListener((Listener)this.myValueListener);
        }
    }

    private void handPinEvent(DeviceBoolEvent<T> t) {
        Boolean val;
        GpioPin pin;
        int chan = t.getChannelId();
        SensorEventHeader header = t.getHeader();
        int seqId = header.getSequenceId();
        if (this.myInputValueSequenceId != seqId) {
            theLogger.log(Level.WARNING, "Unexpected sequenceId for Gpio value: {0}", seqId);
        }
        if ((pin = this.myPins.get(chan)) == null) {
            theLogger.log(Level.WARNING, "Received message for unknown gpio pin {0}", chan);
            return;
        }
        pin.value = val = t.getBoolValue();
        this.notifyListeners(t);
    }

    class GpioValueListener
    implements Listener<DeviceBoolEvent<T>> {
        GpioValueListener() {
        }

        public void handleEvent(DeviceBoolEvent<T> t) {
            RemoteGpioService.this.handPinEvent(t);
        }
    }

    public class GpioPin {
        public int channel;
        public Boolean direction;
        public Boolean value;

        private GpioPin(int channel, Boolean direction, Boolean value) {
            this.channel = channel;
            this.direction = direction;
            this.value = value;
        }
    }
}

