/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.sensor.imu;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.util.DefaultNotifier;
import org.robokind.api.sensor.CompassConfigEvent;
import org.robokind.api.sensor.DeviceReadPeriodEvent;
import org.robokind.api.sensor.FilteredVector3Event;
import org.robokind.api.sensor.SensorEventHeader;
import org.robokind.api.sensor.imu.CompassService;

public class RemoteCompassServiceClient<T extends SensorEventHeader>
extends DefaultNotifier<FilteredVector3Event>
implements CompassService<T> {
    private static final Logger theLogger = Logger.getLogger(RemoteCompassServiceClient.class.getName());
    private Notifier<CompassConfigEvent<T>> myConfigSender;
    private Notifier<DeviceReadPeriodEvent<T>> myReadPeriodSender;
    private Notifier<FilteredVector3Event> myInputValueReceiver;
    private CompassValueListener myEventListener;

    public RemoteCompassServiceClient(Notifier<CompassConfigEvent<T>> configSender, Notifier<DeviceReadPeriodEvent<T>> readPeriodSender, Notifier<FilteredVector3Event> inputValueReceiver) {
        if (configSender == null || readPeriodSender == null || inputValueReceiver == null) {
            theLogger.log(Level.SEVERE, "Null parameters.");
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        this.myConfigSender = configSender;
        this.myReadPeriodSender = readPeriodSender;
        this.myInputValueReceiver = inputValueReceiver;
        this.myEventListener = new CompassValueListener();
        this.myInputValueReceiver.addListener((Listener)this.myEventListener);
    }

    @Override
    public void sendConfig(CompassConfigEvent<T> config) {
        if (config == null) {
            theLogger.log(Level.WARNING, "Null config.");
            throw new IllegalArgumentException("Config cannot be null.");
        }
        this.myConfigSender.notifyListeners(config);
    }

    @Override
    public void setReadPeriod(DeviceReadPeriodEvent<T> readPeriod) {
        if (readPeriod == null) {
            theLogger.log(Level.WARNING, "Null read period.");
            throw new IllegalArgumentException("Read period cannot be null.");
        }
        this.myReadPeriodSender.notifyListeners(readPeriod);
    }

    class CompassValueListener
    implements Listener<FilteredVector3Event> {
        CompassValueListener() {
        }

        public void handleEvent(FilteredVector3Event t) {
            RemoteCompassServiceClient.this.notifyListeners(t);
        }
    }
}

