/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.api.speech;

import org.robokind.api.common.utils.Listener;

/**
 * The SpeechService provides a basic interface for an service providing 
 * Text-to-Speech or equivalent capabilities.
 * 
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface SpeechService {
    public final static String PROP_ID = "speechServiceId";
    
    public String getSpeechServiceId();
    /**
     * Starts the SpeechService, making it ready to speak.
     * @throws Exception 
     */
    public void start() throws Exception;
    /**
     * Sends the SpeechService text to speak.
     * @param text the text to speak
     */
    public void speak(String text);
    /**
     * Closes a SpeechService, leaving it unable to speak.
     */
    public void close();
    
    /**
     * Adds a Listener to be notified when a speech request is made.
     * @param listener the Listener to be notified
     */
    public void addRequestListener(Listener<SpeechRequest> listener);
    /**
     * Removes a Listener from being notified when a speech request is made.
     * @param listener the Listener to remove
     */
    public void removeRequestListener(Listener<SpeechRequest> listener);
        
    /**
     * Adds a Listener to be notified when a speech event occurs.
     * @param listener the Listener to be notified
     */
    public void addSpeechEventListener(Listener<SpeechEvent> listener);
    /**
     * Removes a Listener from being notified when a speech event occurs.
     * @param listener the Listener to remove
     */
    public void removeSpeechEventListener(Listener<SpeechEvent> listener);
}
